/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.executor;

import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowExecuteType;
import cn.sliew.carp.framework.dag.algorithm.DAG;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowInstance;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import cn.sliew.carp.module.workflow.internal.executor.WorkflowInstanceExecutor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WorkflowInstanceExecutorManager
implements InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceExecutorManager.class);
    @Autowired
    private List<WorkflowInstanceExecutor> executors;
    private Map<CarpWorkflowExecuteType, WorkflowInstanceExecutor> registry = new HashMap<CarpWorkflowExecuteType, WorkflowInstanceExecutor>();
    private ThreadPoolTaskExecutor taskExecutor;

    public void afterPropertiesSet() throws Exception {
        if (!CollectionUtils.isEmpty(this.executors)) {
            this.executors.stream().forEach(handler -> this.registry.put(handler.getExecuteType(), (WorkflowInstanceExecutor)handler));
        }
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(5);
        executor.setCorePoolSize(1);
        executor.setThreadNamePrefix("workflow-instance-execute-thread-pool-");
        executor.initialize();
        this.taskExecutor = executor;
    }

    public void destroy() throws Exception {
        if (this.taskExecutor != null) {
            this.taskExecutor.shutdown();
        }
    }

    public CompletableFuture execute(CarpWorkflowExecuteType executeType, WorkflowInstance instance, DAG<WorkflowTaskInstance> dag) {
        if (!this.registry.containsKey(executeType)) {
            throw new RuntimeException("unknown workflow instance execute type: " + executeType.getLabel() + "[" + executeType.getValue() + "]");
        }
        WorkflowInstanceExecutor handler = this.registry.get(executeType);
        return CompletableFuture.runAsync(() -> handler.execute(instance, dag), (Executor)this.taskExecutor).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                log.error("workflow instance execute failed", throwable);
            }
        });
    }
}

