/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.api.configuration;

import cn.sliew.carp.module.scheduler.api.annotation.CarpJob;
import cn.sliew.carp.module.scheduler.api.executor.DefaultJobThreadRepository;
import cn.sliew.carp.module.scheduler.api.executor.DefaultJobexecutorManager;
import cn.sliew.carp.module.scheduler.api.executor.InMemoryJobHandlerFactoryRegistry;
import cn.sliew.carp.module.scheduler.api.executor.JavaJobExecutor;
import cn.sliew.carp.module.scheduler.api.executor.JobExecutor;
import cn.sliew.carp.module.scheduler.api.executor.JobExecutorManager;
import cn.sliew.carp.module.scheduler.api.executor.JobHandlerFactoryRegistry;
import cn.sliew.carp.module.scheduler.api.executor.handler.bean.BeanJobHandlerFactory;
import cn.sliew.carp.module.scheduler.api.executor.handler.method.MethodJobhandlerFactory;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={CarpJob.class})
public class CarpJobAutoConfiguration {
    @Bean
    public MethodJobhandlerFactory methodJobhandlerFactory() {
        return new MethodJobhandlerFactory();
    }

    @Bean
    public BeanJobHandlerFactory beanJobHandlerFactory() {
        return new BeanJobHandlerFactory();
    }

    @Bean
    public JobHandlerFactoryRegistry jobHandlerFactoryRegistry(MethodJobhandlerFactory methodJobhandlerFactory, BeanJobHandlerFactory beanJobHandlerFactory) {
        InMemoryJobHandlerFactoryRegistry registry = new InMemoryJobHandlerFactoryRegistry();
        registry.put(methodJobhandlerFactory.getType(), methodJobhandlerFactory);
        registry.put(beanJobHandlerFactory.getType(), beanJobHandlerFactory);
        return registry;
    }

    @Bean
    public JobExecutor javaJobExecutor(JobHandlerFactoryRegistry jobHandlerFactoryRegistry) {
        return new JavaJobExecutor(jobHandlerFactoryRegistry, new DefaultJobThreadRepository());
    }

    @Bean
    public JobExecutorManager jobExecutorManager(List<JobExecutor> executors) {
        return new DefaultJobexecutorManager(executors);
    }
}

