/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.util.reflection;

import cn.sliew.carp.framework.common.reflection.JobDetails;
import cn.sliew.carp.framework.common.reflection.JobDetailsAsmGenerator;
import cn.sliew.carp.framework.common.reflection.lambdas.JobLambda;
import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.JacksonUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

public final class SerializedLambdaUtil
extends Enum<SerializedLambdaUtil> {
    private static final /* synthetic */ SerializedLambdaUtil[] $VALUES;

    public static SerializedLambdaUtil[] values() {
        return (SerializedLambdaUtil[])$VALUES.clone();
    }

    public static SerializedLambdaUtil valueOf(String name) {
        return Enum.valueOf(SerializedLambdaUtil.class, name);
    }

    public static <T> SerializedLambda toSerializedLambda(T value) {
        if (!value.getClass().isSynthetic()) {
            throw new IllegalArgumentException("support lambda expression only");
        }
        if (!(value instanceof Serializable)) {
            throw new RuntimeException("lambda must be Serializable");
        }
        try {
            Method writeReplaceMethod = value.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            ReflectionUtils.makeAccessible(writeReplaceMethod);
            return (SerializedLambda)writeReplaceMethod.invoke(value, new Object[0]);
        }
        catch (Exception ignored) {
            Rethrower.throwAs((Throwable)ignored);
            return null;
        }
    }

    public static String toFQClassName(String byteCodeName) {
        return byteCodeName.replace("/", ".");
    }

    public static String toFQResource(String byteCodeName) {
        return byteCodeName.replace(".", "/");
    }

    public static InputStream getLambdaDeclaringClassAsInputStream(SerializedLambda lambda) {
        String location = SerializedLambdaUtil.getClassLocationOfLambda(lambda);
        return lambda.getClass().getResourceAsStream(location);
    }

    public static String getClassLocationOfLambda(SerializedLambda lambda) {
        String name = lambda.getImplClass();
        return "/" + SerializedLambdaUtil.toFQResource(name.substring(0, name.indexOf("$$"))) + ".class";
    }

    public static SerializedLambda testLambda(JobLambda invocation) {
        return SerializedLambdaUtil.toSerializedLambda(invocation);
    }

    public static JobDetails testJobDetails(JobLambda invocation) {
        JobDetailsAsmGenerator generator = new JobDetailsAsmGenerator();
        return generator.toJobDetails(invocation);
    }

    public static void main(String[] args) {
        SerializedLambdaUtil.testJobDetails();
    }

    private static void testJobDetails() {
        String echo = "hello, lambda";
        JobDetails jobDetails = SerializedLambdaUtil.testJobDetails(() -> System.out.println(echo));
        System.out.println(JacksonUtil.toJsonString((Object)jobDetails));
    }

    private static void testSerializedLambda() {
        String echo = "hello, lambda";
        SerializedLambda serializedLambda = SerializedLambdaUtil.testLambda(() -> System.out.println(echo));
        System.out.println(serializedLambda.getImplClass());
        System.out.println(serializedLambda.getImplMethodName());
        System.out.println(serializedLambda.getImplMethodKind());
        System.out.println(serializedLambda.getImplMethodSignature());
        System.out.println(serializedLambda.getFunctionalInterfaceClass());
        System.out.println(serializedLambda.getFunctionalInterfaceMethodName());
        System.out.println(serializedLambda.getFunctionalInterfaceMethodSignature());
        System.out.println(serializedLambda.getCapturingClass());
        int capturedArgCount = serializedLambda.getCapturedArgCount();
        for (int i = 0; i < capturedArgCount; ++i) {
            System.out.println(serializedLambda.getCapturedArg(i));
        }
    }

    private static /* synthetic */ SerializedLambdaUtil[] $values() {
        return new SerializedLambdaUtil[0];
    }

    static {
        $VALUES = SerializedLambdaUtil.$values();
    }
}

