/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.system.service.impl;

import cn.sliew.carp.framework.common.dict.CarpEnumDictRegistry;
import cn.sliew.carp.framework.common.dict.DictDefinition;
import cn.sliew.carp.framework.common.dict.DictInstance;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.module.system.service.SysDictDefinitionService;
import cn.sliew.carp.module.system.service.SysDictInstanceService;
import cn.sliew.carp.module.system.service.param.SysDictInstanceParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysDictInstanceServiceImpl
implements SysDictInstanceService {
    @Autowired
    private SysDictDefinitionService sysDictDefinitionService;

    @Override
    public Collection<DictInstance> selectByDefinition(String code) {
        Optional<DictDefinition> optional = this.sysDictDefinitionService.getByCode(code);
        if (optional.isPresent()) {
            return CarpEnumDictRegistry.INSTANCE.getDictInstance(optional.get());
        }
        return Collections.emptyList();
    }

    @Override
    public PageResult<DictInstance> listByPage(SysDictInstanceParam param) {
        Collection<DictInstance> dictInstances = param.getDictDefinitionCode() != null ? this.selectByDefinition(param.getDictDefinitionCode()) : this.selectAll();
        List filteredDictInstances = dictInstances.stream().filter(dictInstance -> {
            if (StringUtils.hasText((String)param.getValue())) {
                return dictInstance.getValue().contains(param.getValue());
            }
            return true;
        }).filter(dictInstance -> {
            if (StringUtils.hasText((String)param.getLabel())) {
                return dictInstance.getLabel().contains(param.getLabel());
            }
            return true;
        }).collect(Collectors.toList());
        PageResult result = new PageResult(param.getCurrent(), param.getPageSize(), Long.valueOf(filteredDictInstances.size()));
        Long from = (param.getCurrent() - 1L) * param.getPageSize();
        Long to = from + param.getPageSize();
        if (from >= (long)filteredDictInstances.size()) {
            result.setRecords(Collections.emptyList());
            return result;
        }
        result.setRecords(filteredDictInstances.subList(from.intValue(), to.intValue() < filteredDictInstances.size() ? to.intValue() : filteredDictInstances.size() - 1));
        return result;
    }

    @Override
    public Collection<DictInstance> selectAll() {
        return CarpEnumDictRegistry.INSTANCE.getAllInstances();
    }
}

