/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class InsertDeParser
extends AbstractDeParser<Insert> {
    private ExpressionVisitor<StringBuilder> expressionVisitor;
    private SelectVisitor<StringBuilder> selectVisitor;

    public InsertDeParser() {
        super(new StringBuilder());
    }

    public InsertDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, SelectVisitor<StringBuilder> selectVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(Insert insert) {
        Iterator<WithItem> iter;
        if (insert.getWithItemsList() != null && !insert.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            iter = insert.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                withItem.accept(this.selectVisitor, null);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("INSERT ");
        if (insert.getModifierPriority() != null) {
            this.buffer.append((Object)insert.getModifierPriority()).append(" ");
        }
        if (insert.getOracleHint() != null) {
            this.buffer.append(insert.getOracleHint()).append(" ");
        }
        if (insert.isModifierIgnore()) {
            this.buffer.append("IGNORE ");
        }
        this.buffer.append("INTO ");
        this.buffer.append(insert.getTable().toString());
        if (insert.getColumns() != null) {
            this.buffer.append(" (");
            iter = insert.getColumns().iterator();
            while (iter.hasNext()) {
                Column column = (Column)((Object)iter.next());
                this.buffer.append(column.getColumnName());
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
        if (insert.getOutputClause() != null) {
            this.buffer.append(insert.getOutputClause().toString());
        }
        if (insert.getSelect() != null) {
            this.buffer.append(" ");
            Select select = insert.getSelect();
            select.accept(this.selectVisitor, null);
        }
        if (insert.getSetUpdateSets() != null) {
            this.buffer.append(" SET ");
            InsertDeParser.deparseUpdateSets(insert.getSetUpdateSets(), this.buffer, this.expressionVisitor);
        }
        if (insert.getDuplicateUpdateSets() != null) {
            this.buffer.append(" ON DUPLICATE KEY UPDATE ");
            InsertDeParser.deparseUpdateSets(insert.getDuplicateUpdateSets(), this.buffer, this.expressionVisitor);
        }
        if (insert.getConflictAction() != null) {
            this.buffer.append(" ON CONFLICT");
            if (insert.getConflictTarget() != null) {
                insert.getConflictTarget().appendTo(this.buffer);
            }
            insert.getConflictAction().appendTo(this.buffer);
        }
        if (insert.getReturningClause() != null) {
            insert.getReturningClause().appendTo(this.buffer);
        }
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> visitor) {
        this.expressionVisitor = visitor;
    }

    public SelectVisitor<StringBuilder> getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor<StringBuilder> visitor) {
        this.selectVisitor = visitor;
    }
}

