/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model.manager;

import cn.sliew.carp.module.http.sync.framework.model.job.JobInfo;
import cn.sliew.carp.module.http.sync.framework.model.manager.LockManager;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultLockManager
implements LockManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultLockManager.class);
    private RedissonClient redissonClient;

    public DefaultLockManager(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Override
    public Long lockReleaseTime(JobInfo jobInfo) {
        RLock lock = this.getLock(this.getLockKey(jobInfo));
        if (lock.isLocked()) {
            return lock.remainTimeToLive();
        }
        return 0L;
    }

    @Override
    public boolean lock(JobInfo jobInfo) {
        RLock lock = this.getLock(this.getLockKey(jobInfo));
        try {
            return lock.tryLock(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean unlock(JobInfo jobInfo) {
        RLock lock = this.getLock(this.getLockKey(jobInfo));
        try {
            if (lock.isLocked()) {
                return lock.forceUnlock();
            }
            return true;
        }
        catch (Exception e) {
            log.error("forceUnlock failed, lock: {}", (Object)lock.getName(), (Object)e);
            return false;
        }
    }

    private String getLockKey(JobInfo jobInfo) {
        return String.format("lock:%s:%s:%s:%s:%s", jobInfo.getGroup(), jobInfo.getJob(), jobInfo.getSubJob().orElse("null"), jobInfo.getAccount().orElse("null"), jobInfo.getSubAccount().orElse("null"));
    }

    private RLock getLock(String key) {
        return this.redissonClient.getLock(key);
    }
}

