/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Descriptor;
import jodd.introspector.Mapper;
import jodd.introspector.MapperFunction;
import jodd.introspector.MapperFunctionInstances;
import jodd.util.ClassUtil;

public class FieldDescriptor
extends Descriptor {
    public static final FieldDescriptor[] EMPTY_ARRAY = new FieldDescriptor[0];
    protected final Field field;
    protected final Type type;
    protected final Class rawType;
    protected final Class rawComponentType;
    protected final Class rawKeyComponentType;
    protected final MapperFunction mapperFunction;

    public FieldDescriptor(ClassDescriptor classDescriptor, Field field) {
        super(classDescriptor, ClassUtil.isPublic((Member)field));
        this.field = field;
        this.type = field.getGenericType();
        this.rawType = ClassUtil.getRawType((Type)this.type, (Class)classDescriptor.getType());
        Class[] componentTypes = ClassUtil.getComponentTypes((Type)this.type, (Class)classDescriptor.getType());
        if (componentTypes != null) {
            this.rawComponentType = componentTypes[componentTypes.length - 1];
            this.rawKeyComponentType = componentTypes[0];
        } else {
            this.rawComponentType = null;
            this.rawKeyComponentType = null;
        }
        ClassUtil.forceAccess((AccessibleObject)field);
        Mapper mapper = field.getAnnotation(Mapper.class);
        this.mapperFunction = mapper != null ? MapperFunctionInstances.get().lookup(mapper.value()) : null;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Class getRawType() {
        return this.rawType;
    }

    public Class getRawComponentType() {
        return this.rawComponentType;
    }

    public Class getRawKeyComponentType() {
        return this.rawKeyComponentType;
    }

    public Class[] resolveRawComponentTypes() {
        return ClassUtil.getComponentTypes((Type)this.type, (Class)this.classDescriptor.getType());
    }

    public String toString() {
        return this.classDescriptor.getType().getSimpleName() + '#' + this.field.getName();
    }
}

