/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.typed.internal;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.RecipientRef;
import org.apache.pekko.actor.typed.Scheduler;
import org.apache.pekko.actor.typed.internal.InternalRecipientRef;
import org.apache.pekko.actor.typed.scaladsl.AskPattern;
import org.apache.pekko.actor.typed.scaladsl.AskPattern$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.query.EventEnvelope;
import org.apache.pekko.persistence.query.PersistenceQuery;
import org.apache.pekko.persistence.query.PersistenceQuery$;
import org.apache.pekko.persistence.query.scaladsl.EventsByPersistenceIdQuery;
import org.apache.pekko.persistence.typed.ReplicaId;
import org.apache.pekko.persistence.typed.ReplicationId;
import org.apache.pekko.persistence.typed.ReplicationId$;
import org.apache.pekko.persistence.typed.internal.BehaviorSetup;
import org.apache.pekko.persistence.typed.internal.EventSourcedBehaviorImpl;
import org.apache.pekko.persistence.typed.internal.FastForwardingFilter;
import org.apache.pekko.persistence.typed.internal.InternalProtocol;
import org.apache.pekko.persistence.typed.internal.ReplicatedEvent;
import org.apache.pekko.persistence.typed.internal.ReplicatedEventAck$;
import org.apache.pekko.persistence.typed.internal.ReplicatedEventMetadata;
import org.apache.pekko.persistence.typed.internal.ReplicationSetup;
import org.apache.pekko.persistence.typed.internal.ReplicationStreamControl;
import org.apache.pekko.persistence.typed.internal.Running;
import org.apache.pekko.persistence.typed.internal.VersionVector;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.InPort;
import org.apache.pekko.stream.OutPort;
import org.apache.pekko.stream.RestartSettings;
import org.apache.pekko.stream.RestartSettings$;
import org.apache.pekko.stream.SystemMaterializer;
import org.apache.pekko.stream.SystemMaterializer$;
import org.apache.pekko.stream.WatchedActorTerminatedException;
import org.apache.pekko.stream.impl.IslandTag;
import org.apache.pekko.stream.impl.LinearTraversalBuilder;
import org.apache.pekko.stream.impl.Transform;
import org.apache.pekko.stream.impl.Traversal;
import org.apache.pekko.stream.impl.TraversalBuilder;
import org.apache.pekko.stream.impl.fusing.Filter;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.RestartSource$;
import org.apache.pekko.stream.scaladsl.RestartWithBackoffSource;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.typed.scaladsl.ActorFlow$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class Running$ {
    public static Running$ MODULE$;
    private final DateTimeFormatter timestampFormatter;
    private final ZoneId UTC;

    static {
        new Running$();
    }

    public <C, E, S> Running.RunningState<S> startReplicationStream(BehaviorSetup<C, E, S> setup, Running.RunningState<S> state2, ReplicationSetup replicationSetup) {
        ActorSystem system = setup.context().system();
        ActorRef ref = setup.context().self();
        PersistenceQuery query = (PersistenceQuery)PersistenceQuery$.MODULE$.apply((ClassicActorSystemProvider)system);
        return (Running.RunningState)replicationSetup.allReplicas().foldLeft(state2, (Function2 & Serializable & scala.Serializable)(state, replicaId) -> {
            ReplicaId replicaId2 = replicaId;
            ReplicaId replicaId3 = replicationSetup.replicaId();
            if (replicaId2 == null ? replicaId3 != null : !((Object)replicaId2).equals(replicaId3)) {
                void ask_makeMessage;
                void withBackoff_settings;
                void withBackoff_sourceFactory;
                ReplicationId pid = ReplicationId$.MODULE$.apply(replicationSetup.replicationContext().replicationId().typeName(), replicationSetup.replicationContext().entityId(), (ReplicaId)replicaId);
                String queryPluginId = (String)replicationSetup.allReplicasAndQueryPlugins().apply(replicaId);
                EventsByPersistenceIdQuery replication = (EventsByPersistenceIdQuery)query.readJournalFor(queryPluginId);
                Timeout timeout = Timeout$.MODULE$.durationToTimeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds());
                Scheduler scheduler = setup.context().system().scheduler();
                ExecutionContextExecutor ec = setup.context().system().executionContext();
                AtomicReference controlRef = new AtomicReference();
                Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
                    EventSourcedBehaviorImpl.GetSeenSequenceNr ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_m;
                    AskPattern.PromiseRef ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_p;
                    InternalRecipientRef internalRecipientRef;
                    void ask$extension_$this;
                    RecipientRef recipientRef = AskPattern$.MODULE$.Askable((RecipientRef)setup.context().self());
                    if (AskPattern.Askable$.MODULE$ == null) {
                        throw null;
                    }
                    if (ask$extension_$this instanceof InternalRecipientRef) {
                        internalRecipientRef = (InternalRecipientRef)ask$extension_$this;
                        if (AskPattern$.MODULE$ == null) {
                            throw null;
                        }
                        ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_p = new AskPattern.PromiseRef(internalRecipientRef, timeout);
                        ActorRef actorRef = ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_p.ref();
                        ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_m = Running$.$anonfun$startReplicationStream$3(replicaId, actorRef);
                        if (ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_p.promiseRef() != null) {
                            ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_p.promiseRef().messageClassName_$eq(ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_m.getClass().getName());
                        }
                    } else {
                        throw new IllegalStateException(new StringBuilder(117).append("Only expect references to be RecipientRef, ActorRefAdapter or ActorSystemAdapter until native system is implemented: ").append(ask$extension_$this.getClass()).toString());
                    }
                    return Source$.MODULE$.futureSource(ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_p.ask(internalRecipientRef, (Object)ask$extension_org$apache$pekko$actor$typed$scaladsl$AskPattern$$askClassic_m, timeout).map((Function1 & Serializable & scala.Serializable)seqNr -> Running$.$anonfun$startReplicationStream$4(replication, pid, replicaId, setup, queryPluginId, controlRef, BoxesRunTime.unboxToLong((Object)seqNr)), (ExecutionContext)ec));
                };
                RestartSettings restartSettings = RestartSettings$.MODULE$.apply(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), 0.2);
                if (RestartSource$.MODULE$ == null) {
                    throw null;
                }
                Function2 & Serializable & scala.Serializable intersect2 = (Function2 & Serializable & scala.Serializable)(eventEnvelope, replyTo) -> {
                    ReplicatedEventMetadata meta = (ReplicatedEventMetadata)eventEnvelope.eventMetadata().get();
                    ReplicatedEvent<Object> re = new ReplicatedEvent<Object>(eventEnvelope.event(), meta.originReplica(), meta.originSequenceNr(), meta.version());
                    return new InternalProtocol.ReplicatedEventEnvelope<Object>(re, (ActorRef<ReplicatedEventAck$>)replyTo);
                };
                if (ActorFlow$.MODULE$ == null) {
                    throw null;
                }
                int ask_ask_parallelism = 2;
                Function2 & Serializable & scala.Serializable ask_ask_askImpl_makeOut = ActorFlow$::$anonfun$ask$1;
                org.apache.pekko.actor.ActorRef ask_ask_askImpl_classicRef = package.TypedActorRefOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorRefOps(ref));
                Source$.MODULE$.fromGraph((Graph)new RestartWithBackoffSource((Function0)withBackoff_sourceFactory, (RestartSettings)withBackoff_settings, false)).via((Graph)((Flow)Flow$.MODULE$.apply().watch(ask_ask_askImpl_classicRef).mapAsync(ask_ask_parallelism, arg_0 -> ActorFlow$.$anonfun$askImpl$1((org.apache.pekko.actor.ActorRef)ask_ask_askImpl_classicRef, (Function2)ask_makeMessage, (Timeout)timeout, (Function2)ask_ask_askImpl_makeOut, arg_0)).mapError((PartialFunction)new /* Unavailable Anonymous Inner Class!! */)).named("ask").recoverWithRetries(1, (PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        if (x1 instanceof WatchedActorTerminatedException) {
                            return (B1)Source$.MODULE$.empty();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        return x1 instanceof WatchedActorTerminatedException;
                    }
                })).runWith((Graph)Sink$.MODULE$.ignore(), ((SystemMaterializer)SystemMaterializer$.MODULE$.apply((ClassicActorSystemProvider)system)).materializer());
                Map x$1 = state.replicationControl().updated(replicaId, (Object)new ReplicationStreamControl(controlRef, setup, (ReplicaId)replicaId){
                    private final AtomicReference controlRef$1;
                    private final BehaviorSetup setup$1;
                    private final ReplicaId replicaId$1;

                    public void fastForward(long sequenceNumber) {
                        ReplicationStreamControl replicationStreamControl = (ReplicationStreamControl)OptionVal$.MODULE$.apply(this.controlRef$1.get());
                        ReplicationStreamControl replicationStreamControl2 = (ReplicationStreamControl)OptionVal.Some$.MODULE$.unapply((Object)replicationStreamControl);
                        if (!OptionVal$.MODULE$.isEmpty$extension((Object)replicationStreamControl2)) {
                            ReplicationStreamControl control = (ReplicationStreamControl)OptionVal$.MODULE$.get$extension((Object)replicationStreamControl2);
                            if (this.setup$1.internalLogger().isDebugEnabled()) {
                                this.setup$1.internalLogger().debug("Fast forward replica [{}] to [{}]", (Object)this.replicaId$1, (Object)BoxesRunTime.boxToLong((long)sequenceNumber));
                            }
                            control.fastForward(sequenceNumber);
                            return;
                        }
                        if (this.setup$1.internalLogger().isDebugEnabled()) {
                            this.setup$1.internalLogger().debug("Ignoring fast forward replica [{}] to [{}], stream not started yet", (Object)this.replicaId$1, (Object)BoxesRunTime.boxToLong((long)sequenceNumber));
                            return;
                        }
                    }
                    {
                        this.controlRef$1 = controlRef$1;
                        this.setup$1 = setup$1;
                        this.replicaId$1 = replicaId$1;
                    }
                });
                long x$2 = state.copy$default$1();
                Object x$3 = state.copy$default$2();
                boolean x$4 = state.copy$default$3();
                VersionVector x$5 = state.copy$default$4();
                Map<ReplicaId, Object> x$6 = state.copy$default$5();
                return state.copy(x$2, x$3, x$4, x$5, x$6, (Map<ReplicaId, ReplicationStreamControl>)x$1);
            }
            return state;
        });
    }

    private DateTimeFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private ZoneId UTC() {
        return this.UTC;
    }

    public String formatTimestamp(long time) {
        return this.timestampFormatter().format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), this.UTC()));
    }

    public static final /* synthetic */ EventSourcedBehaviorImpl.GetSeenSequenceNr $anonfun$startReplicationStream$3(ReplicaId replicaId$1, ActorRef replyTo) {
        return new EventSourcedBehaviorImpl.GetSeenSequenceNr(replicaId$1, (ActorRef<Object>)replyTo);
    }

    public static final /* synthetic */ boolean $anonfun$startReplicationStream$5(ReplicaId replicaId$1, BehaviorSetup setup$1, String queryPluginId$1, EventEnvelope event) {
        Object replicatedMeta;
        Option option = event.eventMetadata();
        if (option instanceof Some && (replicatedMeta = ((Some)option).value()) instanceof ReplicatedEventMetadata) {
            ReplicaId replicaId = ((ReplicatedEventMetadata)replicatedMeta).originReplica();
            return !(replicaId != null ? !((Object)replicaId).equals(replicaId$1) : replicaId$1 != null);
        }
        throw new IllegalArgumentException(new StringBuilder(252).append("Replication stream from replica ").append(replicaId$1).append(" for ").append(setup$1.persistenceId()).append(" contains event ").append("(sequence nr ").append(event.sequenceNr()).append(") without replication metadata. ").append("Is the persistence id used by a regular event sourced actor there or the journal for that replica (").append(queryPluginId$1).append(") ").append("used that does not support Replicated Event Sourcing?").toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Source $anonfun$startReplicationStream$4(EventsByPersistenceIdQuery replication$1, ReplicationId pid$1, ReplicaId replicaId$1, BehaviorSetup setup$1, String queryPluginId$1, AtomicReference controlRef$1, long seqNr) {
        void mapMaterializedValue_f;
        void filter_p;
        Source source = replication$1.eventsByPersistenceId(pid$1.persistenceId().id(), seqNr + 1L, Long.MAX_VALUE);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)event -> BoxesRunTime.boxToBoolean((boolean)Running$.$anonfun$startReplicationStream$5(replicaId$1, setup$1, queryPluginId$1, event));
        if (source == null) {
            throw null;
        }
        Source source2 = ((Source)source.via((Graph)new Filter((Function1)filter_p))).viaMat((Graph)new FastForwardingFilter(), Keep$.MODULE$.right());
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)streamControl -> {
            controlRef$1.set(streamControl);
            return BoxedUnit.UNIT;
        };
        if (source2 == null) {
            throw null;
        }
        Source mapMaterializedValue_this = source2;
        LinearTraversalBuilder linearTraversalBuilder = mapMaterializedValue_this.traversalBuilder();
        if (linearTraversalBuilder == null) {
            throw null;
        }
        LinearTraversalBuilder mapMaterializedValue_transformMat_this = linearTraversalBuilder;
        Traversal mapMaterializedValue_transformMat_x$1 = mapMaterializedValue_transformMat_this.traversalSoFar().concat((Traversal)new Transform((Function1)mapMaterializedValue_f));
        InPort mapMaterializedValue_transformMat_x$2 = mapMaterializedValue_transformMat_this.copy$default$1();
        OutPort mapMaterializedValue_transformMat_x$3 = mapMaterializedValue_transformMat_this.copy$default$2();
        int mapMaterializedValue_transformMat_x$4 = mapMaterializedValue_transformMat_this.copy$default$3();
        int mapMaterializedValue_transformMat_x$5 = mapMaterializedValue_transformMat_this.copy$default$4();
        TraversalBuilder mapMaterializedValue_transformMat_x$6 = mapMaterializedValue_transformMat_this.copy$default$6();
        Attributes mapMaterializedValue_transformMat_x$7 = mapMaterializedValue_transformMat_this.copy$default$7();
        Traversal mapMaterializedValue_transformMat_x$8 = mapMaterializedValue_transformMat_this.copy$default$8();
        IslandTag mapMaterializedValue_transformMat_x$9 = mapMaterializedValue_transformMat_this.copy$default$9();
        return new Source(mapMaterializedValue_transformMat_this.copy(mapMaterializedValue_transformMat_x$2, mapMaterializedValue_transformMat_x$3, mapMaterializedValue_transformMat_x$4, mapMaterializedValue_transformMat_x$5, mapMaterializedValue_transformMat_x$1, mapMaterializedValue_transformMat_x$6, mapMaterializedValue_transformMat_x$7, mapMaterializedValue_transformMat_x$8, mapMaterializedValue_transformMat_x$9), mapMaterializedValue_this.shape());
    }

    private Running$() {
        MODULE$ = this;
        this.timestampFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        this.UTC = ZoneId.of("UTC");
    }
}

