/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.plugin.plugin.update;

import cn.sliew.carp.module.plugin.plugin.update.PluginRelease;
import cn.sliew.carp.module.plugin.plugin.update.RemotePluginInfo;
import cn.sliew.carp.module.plugin.plugin.update.RemotePluginRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.pf4j.VersionManager;

public class UpdateManager {
    private List<RemotePluginRepository> repositories;
    private PluginManager pluginManager;

    public UpdateManager(List<RemotePluginRepository> repositories, PluginManager pluginManager) {
        this.repositories = repositories;
        this.pluginManager = pluginManager;
    }

    public boolean hasUpdates(String repositoryId) {
        List<RemotePluginInfo> updates = this.getUpdates(repositoryId);
        return CollectionUtils.isEmpty(updates);
    }

    public List<RemotePluginInfo> getUpdates(String repositoryId) {
        ArrayList<RemotePluginInfo> updates = new ArrayList<RemotePluginInfo>();
        for (PluginWrapper installed : this.pluginManager.getPlugins()) {
            String pluginId = installed.getPluginId();
            if (!this.hasPluginUpdate(repositoryId, pluginId)) continue;
        }
        return updates;
    }

    public boolean hasPluginUpdate(String repositoryId, String pluginId) {
        Optional<RemotePluginInfo> optional = this.getPlugins(repositoryId).stream().filter(remotePluginInfo -> Objects.equals(remotePluginInfo.getId(), pluginId)).findFirst();
        if (optional.isEmpty()) {
            return false;
        }
        String installedVersion = this.pluginManager.getPlugin(pluginId).getDescriptor().getVersion();
        return false;
    }

    public PluginRelease getLastPluginRelease(RemotePluginInfo pluginInfo) {
        VersionManager versionManager = this.pluginManager.getVersionManager();
        String systemVersion = this.pluginManager.getSystemVersion();
        return null;
    }

    public boolean hasAvailablePlugins(String repositoryId) {
        List<RemotePluginInfo> availablePlugins = this.getAvailablePlugins(repositoryId);
        return CollectionUtils.isNotEmpty(availablePlugins);
    }

    public List<RemotePluginInfo> getAvailablePlugins(String repositoryId) {
        List<RemotePluginInfo> plugins = this.getPlugins(repositoryId);
        for (RemotePluginInfo pluginInfo : this.getPlugins(repositoryId)) {
            if (this.pluginManager.getPlugin(pluginInfo.getId()) != null) continue;
            plugins.add(pluginInfo);
        }
        return plugins;
    }

    private List<RemotePluginInfo> getPlugins(String repositoryId) {
        return this.repositories.stream().filter(r -> r.getId().equals(repositoryId)).findFirst().map(RemotePluginRepository::getAll).orElse(Collections.emptyList());
    }
}

