/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.plugin.service.impl;

import cn.hutool.http.HttpUtil;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.common.nio.FileUtil;
import cn.sliew.carp.framework.spring.util.SystemUtil;
import cn.sliew.carp.module.plugin.repository.entity.CarpPluginRelease;
import cn.sliew.carp.module.plugin.repository.mapper.CarpPluginReleaseMapper;
import cn.sliew.carp.module.plugin.service.CarpPluginReleaseService;
import cn.sliew.carp.module.plugin.service.convert.CarpPluginReleaseConvert;
import cn.sliew.carp.module.plugin.service.dto.CarpPluginReleaseDTO;
import cn.sliew.carp.module.plugin.service.param.CarpPluginReleasePageParam;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Service;

@Service
public class CarpPluginReleaseServiceImpl
extends ServiceImpl<CarpPluginReleaseMapper, CarpPluginRelease>
implements CarpPluginReleaseService {
    @Override
    public PageResult<CarpPluginReleaseDTO> page(CarpPluginReleasePageParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CarpPluginRelease.class).eq(CarpPluginRelease::getPluginId, (Object)param.getPluginId())).orderByAsc(CarpPluginRelease::getVersion);
        Page carpPluginReleasePage = (Page)this.page((IPage)page, (Wrapper)queryChainWrapper);
        PageResult pageResult = new PageResult(Long.valueOf(carpPluginReleasePage.getCurrent()), Long.valueOf(carpPluginReleasePage.getSize()), Long.valueOf(carpPluginReleasePage.getTotal()));
        pageResult.setRecords(CarpPluginReleaseConvert.INSTANCE.toDto(carpPluginReleasePage.getRecords()));
        return pageResult;
    }

    @Override
    public List<CarpPluginReleaseDTO> list(CarpPluginReleasePageParam param) {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CarpPluginRelease.class).eq(CarpPluginRelease::getPluginId, (Object)param.getPluginId())).orderByAsc(CarpPluginRelease::getVersion);
        List entities = this.list((Wrapper)queryChainWrapper);
        return CarpPluginReleaseConvert.INSTANCE.toDto(entities);
    }

    @Override
    public CarpPluginReleaseDTO get(Long id) {
        CarpPluginRelease entity = (CarpPluginRelease)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("plugin release not exists for id: " + id)));
        return (CarpPluginReleaseDTO)((Object)CarpPluginReleaseConvert.INSTANCE.toDto((Object)entity));
    }

    @Override
    public CarpPluginReleaseDTO getByUuid(String pluginUuid) {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(CarpPluginRelease.class).eq(CarpPluginRelease::getUuid, (Object)pluginUuid);
        CarpPluginRelease entity = (CarpPluginRelease)((Object)this.getOne((Wrapper)queryChainWrapper));
        return (CarpPluginReleaseDTO)((Object)CarpPluginReleaseConvert.INSTANCE.toDto((Object)entity));
    }

    @Override
    public Path internalDownloadPlugin(CarpPluginReleaseDTO dto) throws IOException {
        Path path = FileUtil.createFile((Path)SystemUtil.getPluginsPath(), (String)FilenameUtils.getName((String)dto.getUrl()));
        HttpUtil.downloadFileFromUrl((String)dto.getUrl(), (String)path.toAbsolutePath().toFile().getAbsolutePath());
        return path;
    }
}

