/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import jnr.ffi.Pointer;
import jnr.ffi.provider.MemoryManager;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.Library;

public final class ByteArrayProxy
extends BufferProxy<byte[]> {
    public static final BufferProxy<byte[]> PROXY_BA = new ByteArrayProxy();
    private static final MemoryManager MEM_MGR = Library.RUNTIME.getMemoryManager();

    private ByteArrayProxy() {
    }

    public static int compareArrays(byte[] o1, byte[] o2) {
        Objects.requireNonNull(o1);
        Objects.requireNonNull(o2);
        if (o1 == o2) {
            return 0;
        }
        int minLength = Math.min(o1.length, o2.length);
        for (int i = 0; i < minLength; ++i) {
            int rw;
            int lw = Byte.toUnsignedInt(o1[i]);
            int result = Integer.compareUnsigned(lw, rw = Byte.toUnsignedInt(o2[i]));
            if (result == 0) continue;
            return result;
        }
        return o1.length - o2.length;
    }

    @Override
    protected byte[] allocate() {
        return new byte[0];
    }

    protected int compare(byte[] o1, byte[] o2) {
        return ByteArrayProxy.compareArrays(o1, o2);
    }

    @Override
    protected void deallocate(byte[] buff) {
    }

    @Override
    protected byte[] getBytes(byte[] buffer) {
        return Arrays.copyOf(buffer, buffer.length);
    }

    @Override
    protected Comparator<byte[]> getComparator(DbiFlags ... flags) {
        return this::compare;
    }

    @Override
    protected void in(byte[] buffer, Pointer ptr, long ptrAddr) {
        Pointer pointer = MEM_MGR.allocateDirect(buffer.length);
        pointer.put(0L, buffer, 0, buffer.length);
        ptr.putLong(0L, (long)buffer.length);
        ptr.putAddress(8L, pointer.address());
    }

    @Override
    protected void in(byte[] buffer, int size, Pointer ptr, long ptrAddr) {
    }

    @Override
    protected byte[] out(byte[] buffer, Pointer ptr, long ptrAddr) {
        long addr = ptr.getAddress(8L);
        int size = (int)ptr.getLong(0L);
        Pointer pointer = MEM_MGR.newPointer(addr, (long)size);
        byte[] bytes = new byte[size];
        pointer.get(0L, bytes, 0, size);
        return bytes;
    }
}

