/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.lang.reflect.Field;
import java.util.Comparator;
import jnr.ffi.Pointer;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.LmdbException;
import org.lmdbjava.UnsafeAccess;

public final class ByteBufProxy
extends BufferProxy<ByteBuf> {
    public static final BufferProxy<ByteBuf> PROXY_NETTY = new ByteBufProxy();
    private static final int BUFFER_RETRIES = 10;
    private static final String FIELD_NAME_ADDRESS = "memoryAddress";
    private static final String FIELD_NAME_LENGTH = "length";
    private static final String NAME = "io.netty.buffer.PooledUnsafeDirectByteBuf";
    private final long lengthOffset;
    private final long addressOffset;
    private final PooledByteBufAllocator nettyAllocator;

    private ByteBufProxy() {
        this(PooledByteBufAllocator.DEFAULT);
    }

    public ByteBufProxy(PooledByteBufAllocator allocator) {
        this.nettyAllocator = allocator;
        try {
            ByteBuf initBuf = this.allocate();
            initBuf.release();
            Field address = ByteBufProxy.findField(NAME, FIELD_NAME_ADDRESS);
            Field length = ByteBufProxy.findField(NAME, FIELD_NAME_LENGTH);
            this.addressOffset = UnsafeAccess.UNSAFE.objectFieldOffset(address);
            this.lengthOffset = UnsafeAccess.UNSAFE.objectFieldOffset(length);
        }
        catch (SecurityException e) {
            throw new LmdbException("Field access error", e);
        }
    }

    static Field findField(String c, String name) {
        Class<?> clazz;
        try {
            clazz = Class.forName(c);
        }
        catch (ClassNotFoundException e) {
            throw new LmdbException(c + " class unavailable", e);
        }
        while (true) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new LmdbException(name + " not found");
            }
            break;
        }
    }

    @Override
    protected ByteBuf allocate() {
        for (int i = 0; i < 10; ++i) {
            ByteBuf bb = this.nettyAllocator.directBuffer();
            if (NAME.equals(bb.getClass().getName())) {
                return bb;
            }
            bb.release();
        }
        throw new IllegalStateException("Netty buffer must be io.netty.buffer.PooledUnsafeDirectByteBuf");
    }

    protected int compare(ByteBuf o1, ByteBuf o2) {
        return o1.compareTo(o2);
    }

    @Override
    protected Comparator<ByteBuf> getComparator(DbiFlags ... flags) {
        return this::compare;
    }

    @Override
    protected void deallocate(ByteBuf buff) {
        buff.release();
    }

    @Override
    protected byte[] getBytes(ByteBuf buffer) {
        byte[] dest = new byte[buffer.capacity()];
        buffer.getBytes(0, dest);
        return dest;
    }

    @Override
    protected void in(ByteBuf buffer, Pointer ptr, long ptrAddr) {
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 0L, buffer.writerIndex() - buffer.readerIndex());
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 8L, buffer.memoryAddress() + (long)buffer.readerIndex());
    }

    @Override
    protected void in(ByteBuf buffer, int size, Pointer ptr, long ptrAddr) {
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 0L, size);
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 8L, buffer.memoryAddress() + (long)buffer.readerIndex());
    }

    @Override
    protected ByteBuf out(ByteBuf buffer, Pointer ptr, long ptrAddr) {
        long addr = UnsafeAccess.UNSAFE.getLong(ptrAddr + 8L);
        long size = UnsafeAccess.UNSAFE.getLong(ptrAddr + 0L);
        UnsafeAccess.UNSAFE.putLong(buffer, this.addressOffset, addr);
        UnsafeAccess.UNSAFE.putInt(buffer, this.lengthOffset, (int)size);
        buffer.clear().writerIndex((int)size);
        return buffer;
    }
}

