/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.delivery.internal;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.DispatcherSelector$;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.delivery.ConsumerController;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$State$;
import org.apache.pekko.actor.typed.delivery.ProducerController;
import org.apache.pekko.actor.typed.delivery.internal.ChunkedMessage;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$DurableQueueTerminated$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$ResendFirst$;
import org.apache.pekko.actor.typed.internal.ActorFlightRecorder;
import org.apache.pekko.actor.typed.internal.ActorFlightRecorder$;
import org.apache.pekko.actor.typed.internal.BehaviorImpl;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$DeferredBehavior$;
import org.apache.pekko.actor.typed.internal.DeliveryFlightRecorder;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.TimerScheduler;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.LineNumbers$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;

public final class ProducerControllerImpl$ {
    public static ProducerControllerImpl$ MODULE$;

    static {
        new ProducerControllerImpl$();
    }

    /*
     * WARNING - void declaration
     */
    public <A> Behavior<ProducerController.Command<A>> apply(String producerId, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ProducerController.Settings settings, ClassTag<A> evidence$1) {
        void setup_factory;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)context -> {
            void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_consumerController;
            void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_thenBecomeActive;
            void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_initialState;
            void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_producer;
            ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery().producerCreated(producerId, context.self().path());
            Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producerId"), (Object)producerId)}));
            context.setLoggerName("org.apache.pekko.actor.typed.delivery.ProducerController");
            Option durableQueue = MODULE$.askLoadState((ActorContext<ProducerControllerImpl.InternalCommand>)context, durableQueueBehavior, settings);
            Function3 & Serializable & scala.Serializable intersect = (Function3 & Serializable & scala.Serializable)(producer, consumerController, loadedState) -> {
                void createState_self;
                Function1 & Serializable & scala.Serializable send = (Function1 & Serializable & scala.Serializable)x$1 -> {
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(consumerController), x$1);
                    return BoxedUnit.UNIT;
                };
                ActorRef actorRef = context.self();
                if (MODULE$ == null) {
                    throw null;
                }
                Vector createState_unconfirmed = (Vector)((TraversableLike)loadedState.unconfirmed().toVector().zipWithIndex(Vector$.MODULE$.canBuildFrom())).map(arg_0 -> ProducerControllerImpl$.$anonfun$createState$1(producerId, (ActorRef)createState_self, arg_0), Vector$.MODULE$.canBuildFrom());
                return MODULE$.becomeActive(producerId, durableQueue, settings, new ProducerControllerImpl.State(false, loadedState.currentSeqNr(), loadedState.highestConfirmedSeqNr(), 1L, (Map<Object, ActorRef<Object>>)Predef$.MODULE$.Map().empty(), true, createState_unconfirmed, Nil$.MODULE$, 0L, loadedState.highestConfirmedSeqNr() + 1L, producer, send), evidence$1);
            };
            Option option = MODULE$.createInitialState(durableQueue.nonEmpty());
            None$ none$ = None$.MODULE$;
            None$ none$2 = None$.MODULE$;
            if (MODULE$ == null) {
                throw null;
            }
            return Behaviors$.MODULE$.withMdc((Map<String, String>)map, (Behavior)((Object)Behaviors$.MODULE$.receiveMessagePartial(new scala.Serializable((Option)org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_producer, (Option)org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_initialState, (Function3)org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_thenBecomeActive, (ActorContext)context, durableQueue, settings, evidence$1, (Option)org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_consumerController){
                public static final long serialVersionUID = 0L;
                private final Option producer$1;
                private final Option initialState$1;
                private final Function3 thenBecomeActive$1;
                private final ActorContext context$5;
                private final Option durableQueue$3;
                private final ProducerController.Settings settings$4;
                private final ClassTag evidence$3$1;
                private final Option consumerController$2;

                public final <A1 extends ProducerControllerImpl.InternalCommand, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    ActorRef<ConsumerController.Command<A>> c;
                    if (x1 instanceof ProducerController.RegisterConsumer && (c = ((ProducerController.RegisterConsumer)x1).consumerController()) instanceof ActorRef) {
                        Option option = this.initialState$1;
                        Option option2 = this.producer$1;
                        if (option2 instanceof Some) {
                            ActorRef p = (ActorRef)((Some)option2).value();
                            if (option instanceof Some) {
                                DurableProducerQueue.State s = (DurableProducerQueue.State)((Some)option).value();
                                return (B1)((Behavior)this.thenBecomeActive$1.apply((Object)p, c, (Object)s));
                            }
                        }
                        return (B1)ProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization(this.context$5, this.producer$1, new Some(c), this.durableQueue$3, this.settings$4, this.initialState$1, this.thenBecomeActive$1, this.evidence$3$1);
                    }
                    if (x1 instanceof ProducerController.Start) {
                        ProducerController.Start start = (ProducerController.Start)x1;
                        Option option = this.initialState$1;
                        Option option3 = this.consumerController$2;
                        if (option3 instanceof Some) {
                            ActorRef c2 = (ActorRef)((Some)option3).value();
                            if (option instanceof Some) {
                                DurableProducerQueue.State s = (DurableProducerQueue.State)((Some)option).value();
                                return (B1)((Behavior)this.thenBecomeActive$1.apply(start.producer(), (Object)c2, (Object)s));
                            }
                        }
                        return (B1)ProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization(this.context$5, new Some(start.producer()), this.consumerController$2, this.durableQueue$3, this.settings$4, this.initialState$1, this.thenBecomeActive$1, this.evidence$3$1);
                    }
                    if (x1 instanceof ProducerControllerImpl.LoadStateReply) {
                        ProducerControllerImpl.LoadStateReply loadStateReply = (ProducerControllerImpl.LoadStateReply)x1;
                        Option option = this.consumerController$2;
                        Option option4 = this.producer$1;
                        if (option4 instanceof Some) {
                            ActorRef p = (ActorRef)((Some)option4).value();
                            if (option instanceof Some) {
                                ActorRef c3 = (ActorRef)((Some)option).value();
                                return (B1)((Behavior)this.thenBecomeActive$1.apply((Object)p, (Object)c3, loadStateReply.state()));
                            }
                        }
                        return (B1)ProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization(this.context$5, this.producer$1, this.consumerController$2, this.durableQueue$3, this.settings$4, new Some(loadStateReply.state()), this.thenBecomeActive$1, this.evidence$3$1);
                    }
                    if (x1 instanceof ProducerControllerImpl.LoadStateFailed) {
                        int attempt = ((ProducerControllerImpl.LoadStateFailed)x1).attempt();
                        if (attempt >= this.settings$4.durableQueueRetryAttempts()) {
                            String errorMessage = new StringBuilder(46).append("LoadState failed after [").append(attempt).append("] attempts, giving up.").toString();
                            this.context$5.log().error(errorMessage);
                            throw new TimeoutException(errorMessage);
                        }
                        this.context$5.log().warn("LoadState failed, attempt [{}] of [{}], retrying.", (Object)BoxesRunTime.boxToInteger((int)attempt), (Object)BoxesRunTime.boxToInteger((int)this.settings$4.durableQueueRetryAttempts()));
                        ProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$askLoadState(this.context$5, this.durableQueue$3, this.settings$4, attempt + 1);
                        return (B1)Behaviors$.MODULE$.same();
                    }
                    if (ProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(x1)) {
                        throw new IllegalStateException("DurableQueue was unexpectedly terminated.");
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(ProducerControllerImpl.InternalCommand x1) {
                    if (x1 instanceof ProducerController.RegisterConsumer && ((ProducerController.RegisterConsumer)x1).consumerController() instanceof ActorRef) {
                        return true;
                    }
                    if (x1 instanceof ProducerController.Start) {
                        return true;
                    }
                    if (x1 instanceof ProducerControllerImpl.LoadStateReply) {
                        return true;
                    }
                    if (x1 instanceof ProducerControllerImpl.LoadStateFailed) {
                        return true;
                    }
                    return ProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(x1);
                }
                {
                    this.producer$1 = producer$1;
                    this.initialState$1 = initialState$1;
                    this.thenBecomeActive$1 = thenBecomeActive$1;
                    this.context$5 = context$5;
                    this.durableQueue$3 = durableQueue$3;
                    this.settings$4 = settings$4;
                    this.evidence$3$1 = evidence$3$1;
                    this.consumerController$2 = consumerController$2;
                }
            })), ClassTag$.MODULE$.apply(ProducerControllerImpl.InternalCommand.class));
        };
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        if (BehaviorImpl$DeferredBehavior$.MODULE$ == null) {
            throw null;
        }
        return new BehaviorImpl.DeferredBehavior<T>((Function1)setup_factory){
            private final Function1 factory$1;

            public Behavior<T> apply(TypedActorContext<T> ctx) {
                return (Behavior)this.factory$1.apply(ctx.asScala());
            }

            public String toString() {
                return new StringBuilder(10).append("Deferred(").append(LineNumbers$.MODULE$.apply((Object)this.factory$1)).append(")").toString();
            }
            {
                this.factory$1 = factory$1;
            }
        }.narrow();
    }

    /*
     * WARNING - void declaration
     */
    public <A> Behavior<ProducerController.Command<A>> apply(String producerId, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ProducerController.Settings settings, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> send, ClassTag<A> evidence$2) {
        void setup_factory;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)context -> {
            void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_consumerController;
            void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_thenBecomeActive;
            void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_initialState;
            void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization_producer;
            ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery().producerCreated(producerId, context.self().path());
            Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producerId"), (Object)producerId)}));
            context.setLoggerName("org.apache.pekko.actor.typed.delivery.ProducerController");
            Option durableQueue = MODULE$.askLoadState((ActorContext<ProducerControllerImpl.InternalCommand>)context, durableQueueBehavior, settings);
            Function3 & Serializable & scala.Serializable intersect = (Function3 & Serializable & scala.Serializable)(producer, x$2, loadedState) -> {
                void createState_self;
                ActorRef actorRef = context.self();
                if (MODULE$ == null) {
                    throw null;
                }
                Vector createState_unconfirmed = (Vector)((TraversableLike)loadedState.unconfirmed().toVector().zipWithIndex(Vector$.MODULE$.canBuildFrom())).map(arg_0 -> ProducerControllerImpl$.$anonfun$createState$1(producerId, (ActorRef)createState_self, arg_0), Vector$.MODULE$.canBuildFrom());
                return MODULE$.becomeActive(producerId, durableQueue, settings, new ProducerControllerImpl.State(false, loadedState.currentSeqNr(), loadedState.highestConfirmedSeqNr(), 1L, (Map<Object, ActorRef<Object>>)Predef$.MODULE$.Map().empty(), true, createState_unconfirmed, Nil$.MODULE$, 0L, loadedState.highestConfirmedSeqNr() + 1L, producer, send), evidence$2);
            };
            Option option = MODULE$.createInitialState(durableQueue.nonEmpty());
            Some some = new Some(context.system().deadLetters());
            None$ none$ = None$.MODULE$;
            if (MODULE$ == null) {
                throw null;
            }
            return Behaviors$.MODULE$.withMdc((Map<String, String>)map, (Behavior)((Object)Behaviors$.MODULE$.receiveMessagePartial(new /* invalid duplicate definition of identical inner class */)), ClassTag$.MODULE$.apply(ProducerControllerImpl.InternalCommand.class));
        };
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        if (BehaviorImpl$DeferredBehavior$.MODULE$ == null) {
            throw null;
        }
        return new /* invalid duplicate definition of identical inner class */.narrow();
    }

    private <A> Option<ActorRef<DurableProducerQueue.Command<A>>> askLoadState(ActorContext<ProducerControllerImpl.InternalCommand> context, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ProducerController.Settings settings) {
        return durableQueueBehavior.map((Function1 & Serializable & scala.Serializable)b -> {
            ActorRef ref = context.spawn(b, "durable", DispatcherSelector$.MODULE$.sameAsParent());
            context.watchWith(ref, ProducerControllerImpl$DurableQueueTerminated$.MODULE$);
            MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$askLoadState(context, (Option)new Some(ref), settings, 1);
            return ref;
        });
    }

    public <A> void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$askLoadState(ActorContext<ProducerControllerImpl.InternalCommand> context, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, int attempt) {
        Timeout loadTimeout = Timeout$.MODULE$.durationToTimeout(settings.durableQueueRequestTimeout());
        durableQueue.foreach((Function1 & Serializable & scala.Serializable)ref -> {
            context.ask(ref, (Function1 & Serializable & scala.Serializable)askReplyTo -> new DurableProducerQueue.LoadState(askReplyTo), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 instanceof Success) {
                    DurableProducerQueue.State s = (DurableProducerQueue.State)((Success)x0$1).value();
                    return new ProducerControllerImpl.LoadStateReply(s);
                }
                if (x0$1 instanceof Failure) {
                    return new ProducerControllerImpl.LoadStateFailed(attempt$1);
                }
                throw new MatchError(x0$1);
            }, loadTimeout, ClassTag$.MODULE$.apply(DurableProducerQueue.State.class));
            return BoxedUnit.UNIT;
        });
    }

    private <A> Option<DurableProducerQueue.State<A>> createInitialState(boolean hasDurableQueue) {
        if (hasDurableQueue) {
            return None$.MODULE$;
        }
        return new Some(DurableProducerQueue$State$.MODULE$.empty());
    }

    private <A> ProducerControllerImpl.State<A> createState(ActorRef<ProducerControllerImpl.InternalCommand> self, String producerId, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> send, ActorRef<ProducerController.RequestNext<A>> producer, DurableProducerQueue.State<A> loadedState) {
        Vector unconfirmed = (Vector)((TraversableLike)loadedState.unconfirmed().toVector().zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                DurableProducerQueue.MessageSent u = (DurableProducerQueue.MessageSent)x0$1._1();
                int i = x0$1._2$mcI$sp();
                return new ConsumerController.SequencedMessage(producerId, u.seqNr(), u.message(), i == 0, u.ack(), self);
            }
            throw new MatchError(null);
        }, Vector$.MODULE$.canBuildFrom());
        return new ProducerControllerImpl.State<A>(false, loadedState.currentSeqNr(), loadedState.highestConfirmedSeqNr(), 1L, (Map<Object, ActorRef<Object>>)Predef$.MODULE$.Map().empty(), true, unconfirmed, Nil$.MODULE$, 0L, loadedState.highestConfirmedSeqNr() + 1L, producer, send);
    }

    public <A> Behavior<ProducerControllerImpl.InternalCommand> org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization(ActorContext<ProducerControllerImpl.InternalCommand> context, Option<ActorRef<ProducerController.RequestNext<A>>> producer, Option<ActorRef<ConsumerController.Command<A>>> consumerController, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, Option<DurableProducerQueue.State<A>> initialState, Function3<ActorRef<ProducerController.RequestNext<A>>, ActorRef<ConsumerController.Command<A>>, DurableProducerQueue.State<A>, Behavior<ProducerControllerImpl.InternalCommand>> thenBecomeActive, ClassTag<A> evidence$3) {
        return (Behavior)((Object)Behaviors$.MODULE$.receiveMessagePartial(new /* invalid duplicate definition of identical inner class */));
    }

    /*
     * WARNING - void declaration
     */
    private <A> Behavior<ProducerControllerImpl.InternalCommand> becomeActive(String producerId, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, ProducerControllerImpl.State<A> state, ClassTag<A> evidence$4) {
        void setup_factory;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)context -> {
            void withTimers_withTimers_setup_factory;
            void withTimers_factory;
            DeliveryFlightRecorder flightRecorder = ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery();
            flightRecorder.producerStarted(producerId, context.self().path());
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)timers -> {
                boolean bl;
                ActorRef msgAdapter = context.messageAdapter((Function1 & Serializable & scala.Serializable)msg -> new ProducerControllerImpl.Msg<Object>(msg), evidence$4);
                if (state.unconfirmed().isEmpty()) {
                    flightRecorder.producerRequestNext(producerId, 1L, 0L);
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(state.producer()), new ProducerController.RequestNext(producerId, 1L, 0L, msgAdapter, context.self()));
                    bl = true;
                } else {
                    context.log().debug("Starting with [{}] unconfirmed.", (Object)BoxesRunTime.boxToInteger((int)state.unconfirmed().size()));
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(context.self()), ProducerControllerImpl$ResendFirst$.MODULE$);
                    bl = false;
                }
                boolean requested = bl;
                return new ProducerControllerImpl((ActorContext<ProducerControllerImpl.InternalCommand>)context, producerId, durableQueue, settings, msgAdapter, (TimerScheduler<ProducerControllerImpl.InternalCommand>)timers, evidence$4).org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(state.copy(requested, state.copy$default$2(), state.copy$default$3(), state.copy$default$4(), state.copy$default$5(), state.copy$default$6(), state.copy$default$7(), state.copy$default$8(), state.copy$default$9(), state.copy$default$10(), state.copy$default$11(), state.copy$default$12()));
            };
            if (Behaviors$.MODULE$ == null) {
                throw null;
            }
            if (TimerSchedulerImpl$.MODULE$ == null) {
                throw null;
            }
            Function1 & Serializable & scala.Serializable intersect2 = arg_0 -> TimerSchedulerImpl$.$anonfun$withTimers$1((Function1)withTimers_factory, arg_0);
            if (Behaviors$.MODULE$ == null) {
                throw null;
            }
            if (BehaviorImpl$DeferredBehavior$.MODULE$ == null) {
                throw null;
            }
            return new /* invalid duplicate definition of identical inner class */;
        };
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        if (BehaviorImpl$DeferredBehavior$.MODULE$ == null) {
            throw null;
        }
        return new /* invalid duplicate definition of identical inner class */;
    }

    public void enforceLocalProducer(ActorRef<?> ref) {
        if (ref.path().address().hasGlobalScope()) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Consumer [").append(ref).append("] should be local.").toString());
        }
    }

    public <A> scala.collection.immutable.Seq<ChunkedMessage> createChunks(A m, int chunkSize, Serialization serialization) {
        byte[] bytes = (byte[])serialization.serialize(m).get();
        Serializer ser = serialization.findSerializerFor(m);
        String manifest = Serializers$.MODULE$.manifestFor(ser, m);
        int serializerId = ser.identifier();
        if (bytes.length <= chunkSize) {
            ChunkedMessage chunkedMessage = new ChunkedMessage(ByteString$.MODULE$.fromArrayUnsafe(bytes), true, true, serializerId, manifest);
            return Nil$.MODULE$.$colon$colon((Object)chunkedMessage);
        }
        Builder builder = package$.MODULE$.Vector().newBuilder();
        Iterator chunksIter = ByteString$.MODULE$.fromArrayUnsafe(bytes).grouped(chunkSize);
        boolean first = true;
        while (chunksIter.hasNext()) {
            ByteString chunk = (ByteString)chunksIter.next();
            boolean firstChunk = first;
            first = false;
            boolean lastChunk = !chunksIter.hasNext();
            builder.$plus$eq((Object)new ChunkedMessage(chunk, firstChunk, lastChunk, serializerId, manifest));
        }
        return (scala.collection.immutable.Seq)builder.result();
    }

    private ProducerControllerImpl$() {
        MODULE$ = this;
    }
}

