/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.statemachine;

import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowTaskInstanceEvent;
import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowTaskInstanceStage;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowTaskInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.publisher.InternalWorkflowTaskInstanceEventPublisher;
import com.alibaba.cola.statemachine.Action;
import com.alibaba.cola.statemachine.StateMachine;
import com.alibaba.cola.statemachine.builder.StateMachineBuilder;
import com.alibaba.cola.statemachine.builder.StateMachineBuilderFactory;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowTaskInstanceStateMachine
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowTaskInstanceStateMachine.class);
    public static final String CONSUMER_GROUP = "WorkflowTaskInstanceStateMachine";
    public static final String EXECUTOR = "WorkflowTaskInstanceExecute";
    @Autowired
    private InternalWorkflowTaskInstanceEventPublisher statusPublisher;
    private StateMachine<CarpWorkflowTaskInstanceStage, CarpWorkflowTaskInstanceEvent, Pair<Long, Throwable>> stateMachine;

    public void afterPropertiesSet() throws Exception {
        StateMachineBuilder builder = StateMachineBuilderFactory.create();
        builder.externalTransition().from((Object)CarpWorkflowTaskInstanceStage.PENDING).to((Object)CarpWorkflowTaskInstanceStage.RUNNING).on((Object)CarpWorkflowTaskInstanceEvent.COMMAND_DEPLOY).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowTaskInstanceStage.RUNNING).to((Object)CarpWorkflowTaskInstanceStage.SUCCESS).on((Object)CarpWorkflowTaskInstanceEvent.PROCESS_SUCCESS).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowTaskInstanceStage.RUNNING).to((Object)CarpWorkflowTaskInstanceStage.FAILURE).on((Object)CarpWorkflowTaskInstanceEvent.PROCESS_FAILURE).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowTaskInstanceStage.RUNNING).to((Object)CarpWorkflowTaskInstanceStage.SUSPEND).on((Object)CarpWorkflowTaskInstanceEvent.COMMAND_SUSPEND).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowTaskInstanceStage.RUNNING).to((Object)CarpWorkflowTaskInstanceStage.TERMINATED).on((Object)CarpWorkflowTaskInstanceEvent.COMMAND_SHUTDOWN).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowTaskInstanceStage.SUSPEND).to((Object)CarpWorkflowTaskInstanceStage.RUNNING).on((Object)CarpWorkflowTaskInstanceEvent.COMMAND_RESUME).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowTaskInstanceStage.SUSPEND).to((Object)CarpWorkflowTaskInstanceStage.TERMINATED).on((Object)CarpWorkflowTaskInstanceEvent.COMMAND_SHUTDOWN).perform(this.doPerform());
        this.stateMachine = builder.build(CONSUMER_GROUP);
    }

    private Action<CarpWorkflowTaskInstanceStage, CarpWorkflowTaskInstanceEvent, Pair<Long, Throwable>> doPerform() {
        return (fromState, toState, eventEnum, pair) -> {
            WorkflowTaskInstanceEventDTO eventDTO = new WorkflowTaskInstanceEventDTO((CarpWorkflowTaskInstanceStage)fromState, (CarpWorkflowTaskInstanceStage)toState, (CarpWorkflowTaskInstanceEvent)eventEnum, (Long)pair.getLeft(), (Throwable)pair.getRight());
            this.statusPublisher.publish(eventDTO);
        };
    }

    public void deploy(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)CarpWorkflowTaskInstanceEvent.COMMAND_DEPLOY, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void shutdown(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)CarpWorkflowTaskInstanceEvent.COMMAND_SHUTDOWN, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void suspend(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)CarpWorkflowTaskInstanceEvent.COMMAND_SUSPEND, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void resume(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)CarpWorkflowTaskInstanceEvent.COMMAND_RESUME, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void onSuccess(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)CarpWorkflowTaskInstanceEvent.PROCESS_SUCCESS, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void onFailure(WorkflowTaskInstance taskInstance, Throwable throwable) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)CarpWorkflowTaskInstanceEvent.PROCESS_FAILURE, (Object)Pair.of((Object)taskInstance.getId(), (Object)throwable));
    }
}

