/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$ClusterShuttingDown$;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsEvents$;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsSnapshot$;
import org.apache.pekko.cluster.Gossip;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Exiting$;
import org.apache.pekko.cluster.MemberStatus$Joining$;
import org.apache.pekko.cluster.MemberStatus$Leaving$;
import org.apache.pekko.cluster.MemberStatus$PreparingForShutdown$;
import org.apache.pekko.cluster.MemberStatus$ReadyForShutdown$;
import org.apache.pekko.cluster.MemberStatus$Removed$;
import org.apache.pekko.cluster.MemberStatus$Up$;
import org.apache.pekko.cluster.MemberStatus$WeaklyUp$;
import org.apache.pekko.cluster.MembershipState;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.util.ccompat.package;
import org.apache.pekko.util.ccompat.package$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.VectorBuilder;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterEvent$ {
    public static ClusterEvent$ MODULE$;

    static {
        new ClusterEvent$();
    }

    public ClusterEvent$InitialStateAsSnapshot$ initialStateAsSnapshot() {
        return ClusterEvent$InitialStateAsSnapshot$.MODULE$;
    }

    public ClusterEvent$InitialStateAsEvents$ initialStateAsEvents() {
        return ClusterEvent$InitialStateAsEvents$.MODULE$;
    }

    public ClusterEvent$ClusterShuttingDown$ getClusterShuttingDownInstance() {
        return ClusterEvent$ClusterShuttingDown$.MODULE$;
    }

    @InternalApi
    public Seq<ClusterEvent.UnreachableMember> diffUnreachable(MembershipState oldState, MembershipState newState) {
        if (newState == oldState) {
            return Nil$.MODULE$;
        }
        Gossip newGossip = newState.latestGossip();
        Set<UniqueAddress> oldUnreachableNodes = oldState.dcReachabilityNoOutsideNodes().allUnreachableOrTerminated();
        return (Seq)newState.dcReachabilityNoOutsideNodes().allUnreachableOrTerminated().iterator().collect((PartialFunction)new scala.Serializable(oldUnreachableNodes, newState, newGossip){
            public static final long serialVersionUID = 0L;
            private final Set oldUnreachableNodes$1;
            private final MembershipState newState$1;
            private final Gossip newGossip$1;

            public final <A1 extends UniqueAddress, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (!this.oldUnreachableNodes$1.contains(x1)) {
                    A1 A1 = x1;
                    UniqueAddress uniqueAddress = this.newState$1.selfUniqueAddress();
                    if (A1 == null ? uniqueAddress != null : !((Object)A1).equals(uniqueAddress)) {
                        return (B1)new ClusterEvent.UnreachableMember(this.newGossip$1.member(x1));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(UniqueAddress x1) {
                if (!this.oldUnreachableNodes$1.contains((Object)x1)) {
                    UniqueAddress uniqueAddress = x1;
                    UniqueAddress uniqueAddress2 = this.newState$1.selfUniqueAddress();
                    if (uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.oldUnreachableNodes$1 = oldUnreachableNodes$1;
                this.newState$1 = newState$1;
                this.newGossip$1 = newGossip$1;
            }
        }).to(package$.MODULE$.genericCompanionToCBF((GenericCompanion)IndexedSeq$.MODULE$));
    }

    @InternalApi
    public Seq<ClusterEvent.ReachableMember> diffReachable(MembershipState oldState, MembershipState newState) {
        if (newState == oldState) {
            return Nil$.MODULE$;
        }
        Gossip newGossip = newState.latestGossip();
        return (Seq)oldState.dcReachabilityNoOutsideNodes().allUnreachable().iterator().collect((PartialFunction)new scala.Serializable(newGossip, newState){
            public static final long serialVersionUID = 0L;
            private final Gossip newGossip$2;
            private final MembershipState newState$2;

            public final <A1 extends UniqueAddress, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (this.newGossip$2.hasMember(x1) && this.newState$2.dcReachabilityNoOutsideNodes().isReachable(x1)) {
                    A1 A1 = x1;
                    UniqueAddress uniqueAddress = this.newState$2.selfUniqueAddress();
                    if (A1 == null ? uniqueAddress != null : !((Object)A1).equals(uniqueAddress)) {
                        return (B1)new ClusterEvent.ReachableMember(this.newGossip$2.member(x1));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(UniqueAddress x1) {
                if (this.newGossip$2.hasMember(x1) && this.newState$2.dcReachabilityNoOutsideNodes().isReachable(x1)) {
                    UniqueAddress uniqueAddress = x1;
                    UniqueAddress uniqueAddress2 = this.newState$2.selfUniqueAddress();
                    if (uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.newGossip$2 = newGossip$2;
                this.newState$2 = newState$2;
            }
        }).to(package$.MODULE$.genericCompanionToCBF((GenericCompanion)IndexedSeq$.MODULE$));
    }

    @InternalApi
    public boolean isDataCenterReachable(MembershipState state, String otherDc) {
        SortedSet unrelatedDcNodes = (SortedSet)state.latestGossip().members().collect((PartialFunction)new scala.Serializable(otherDc, state){
            public static final long serialVersionUID = 0L;
            private final String otherDc$1;
            private final MembershipState state$1;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String string = x1.dataCenter();
                String string2 = this.otherDc$1;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String string3 = x1.dataCenter();
                    String string4 = this.state$1.selfDc();
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        return (B1)x1.uniqueAddress();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Member x1) {
                String string = x1.dataCenter();
                String string2 = this.otherDc$1;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String string3 = x1.dataCenter();
                    String string4 = this.state$1.selfDc();
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.otherDc$1 = otherDc$1;
                this.state$1 = state$1;
            }
        }, SortedSet$.MODULE$.newCanBuildFrom(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
        return state.dcReachabilityWithoutObservationsWithin().remove((Iterable<UniqueAddress>)unrelatedDcNodes).allUnreachable().isEmpty();
    }

    @InternalApi
    public Seq<ClusterEvent.UnreachableDataCenter> diffUnreachableDataCenter(MembershipState oldState, MembershipState newState) {
        if (newState == oldState) {
            return Nil$.MODULE$;
        }
        Set otherDcs = (Set)oldState.latestGossip().allDataCenters().union(newState.latestGossip().allDataCenters()).$minus((Object)newState.selfDc());
        Set oldUnreachableDcs = (Set)otherDcs.filterNot((Function1 & Serializable & scala.Serializable)otherDc -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.MODULE$.isDataCenterReachable(oldState, otherDc)));
        return (Seq)((Set)otherDcs.filterNot((Function1 & Serializable & scala.Serializable)otherDc -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.MODULE$.isDataCenterReachable(newState, otherDc)))).diff((GenSet)oldUnreachableDcs).iterator().map((Function1 & Serializable & scala.Serializable)dataCenter -> new ClusterEvent.UnreachableDataCenter((String)dataCenter)).to(package$.MODULE$.genericCompanionToCBF((GenericCompanion)IndexedSeq$.MODULE$));
    }

    @InternalApi
    public Seq<ClusterEvent.ReachableDataCenter> diffReachableDataCenter(MembershipState oldState, MembershipState newState) {
        if (newState == oldState) {
            return Nil$.MODULE$;
        }
        Set otherDcs = (Set)oldState.latestGossip().allDataCenters().union(newState.latestGossip().allDataCenters()).$minus((Object)newState.selfDc());
        Set oldUnreachableDcs = (Set)otherDcs.filterNot((Function1 & Serializable & scala.Serializable)otherDc -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.MODULE$.isDataCenterReachable(oldState, otherDc)));
        Set currentUnreachableDcs = (Set)otherDcs.filterNot((Function1 & Serializable & scala.Serializable)otherDc -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.MODULE$.isDataCenterReachable(newState, otherDc)));
        return (Seq)oldUnreachableDcs.diff((GenSet)currentUnreachableDcs).iterator().map((Function1 & Serializable & scala.Serializable)dataCenter -> new ClusterEvent.ReachableDataCenter((String)dataCenter)).to(package$.MODULE$.genericCompanionToCBF((GenericCompanion)IndexedSeq$.MODULE$));
    }

    @InternalApi
    public Seq<ClusterEvent.MemberEvent> diffMemberEvents(MembershipState oldState, MembershipState newState) {
        if (newState == oldState) {
            return Nil$.MODULE$;
        }
        Gossip oldGossip = oldState.latestGossip();
        Gossip newGossip = newState.latestGossip();
        SortedSet newMembers = (SortedSet)newGossip.members().diff(oldGossip.members());
        scala.collection.immutable.Iterable changedMembers = (scala.collection.immutable.Iterable)((TraversableLike)new .colon.colon(newGossip.members(), (List)new .colon.colon(oldGossip.members(), (List)Nil$.MODULE$)).flatten((Function1)Predef$.MODULE$.$conforms())).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.uniqueAddress()).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<UniqueAddress, List<Member>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                List list;
                if (x1 != null && (list = (List)x1._2()) instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    Member newMember = (Member)colon2.head();
                    List list2 = colon2.tl$access$1();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        Member oldMember = (Member)colon3.head();
                        List list3 = colon3.tl$access$1();
                        if (Nil$.MODULE$.equals(list3)) {
                            MemberStatus memberStatus = newMember.status();
                            MemberStatus memberStatus2 = oldMember.status();
                            if ((memberStatus != null ? !memberStatus.equals(memberStatus2) : memberStatus2 != null) || newMember.upNumber() != oldMember.upNumber()) {
                                return (B1)newMember;
                            }
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<UniqueAddress, List<Member>> x1) {
                List list;
                if (x1 != null && (list = (List)x1._2()) instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    Member newMember = (Member)colon2.head();
                    List list2 = colon2.tl$access$1();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        Member oldMember = (Member)colon3.head();
                        List list3 = colon3.tl$access$1();
                        if (Nil$.MODULE$.equals(list3)) {
                            MemberStatus memberStatus = newMember.status();
                            MemberStatus memberStatus2 = oldMember.status();
                            if ((memberStatus != null ? !memberStatus.equals(memberStatus2) : memberStatus2 != null) || newMember.upNumber() != oldMember.upNumber()) {
                                return true;
                            }
                        }
                    }
                }
                return false;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Set memberEvents = (Set)package.ImmutableSortedSetOps$.MODULE$.unsorted$extension(package$.MODULE$.ImmutableSortedSetOps((SortedSet)newMembers.$plus$plus((GenTraversableOnce)changedMembers))).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                MemberStatus memberStatus = x2.status();
                MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
                if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Joining$) : memberStatus$Joining$ != null)) {
                    return (B1)new ClusterEvent.MemberJoined(x2);
                }
                MemberStatus memberStatus2 = x2.status();
                MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
                if (!(memberStatus2 != null ? !memberStatus2.equals(memberStatus$WeaklyUp$) : memberStatus$WeaklyUp$ != null)) {
                    return (B1)new ClusterEvent.MemberWeaklyUp(x2);
                }
                MemberStatus memberStatus3 = x2.status();
                MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                if (!(memberStatus3 != null ? !memberStatus3.equals(memberStatus$Up$) : memberStatus$Up$ != null)) {
                    return (B1)new ClusterEvent.MemberUp(x2);
                }
                MemberStatus memberStatus4 = x2.status();
                MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
                if (!(memberStatus4 != null ? !memberStatus4.equals(memberStatus$Leaving$) : memberStatus$Leaving$ != null)) {
                    return (B1)new ClusterEvent.MemberLeft(x2);
                }
                MemberStatus memberStatus5 = x2.status();
                MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                if (!(memberStatus5 != null ? !memberStatus5.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null)) {
                    return (B1)new ClusterEvent.MemberExited(x2);
                }
                MemberStatus memberStatus6 = x2.status();
                MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                if (!(memberStatus6 != null ? !memberStatus6.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                    return (B1)new ClusterEvent.MemberDowned(x2);
                }
                MemberStatus memberStatus7 = x2.status();
                MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
                if (!(memberStatus7 != null ? !memberStatus7.equals(memberStatus$PreparingForShutdown$) : memberStatus$PreparingForShutdown$ != null)) {
                    return (B1)new ClusterEvent.MemberPreparingForShutdown(x2);
                }
                MemberStatus memberStatus8 = x2.status();
                MemberStatus$ReadyForShutdown$ memberStatus$ReadyForShutdown$ = MemberStatus$ReadyForShutdown$.MODULE$;
                if (!(memberStatus8 != null ? !memberStatus8.equals(memberStatus$ReadyForShutdown$) : memberStatus$ReadyForShutdown$ != null)) {
                    return (B1)new ClusterEvent.MemberReadyForShutdown(x2);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Member x2) {
                MemberStatus memberStatus = x2.status();
                MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
                if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Joining$) : memberStatus$Joining$ != null)) {
                    return true;
                }
                MemberStatus memberStatus2 = x2.status();
                MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
                if (!(memberStatus2 != null ? !memberStatus2.equals(memberStatus$WeaklyUp$) : memberStatus$WeaklyUp$ != null)) {
                    return true;
                }
                MemberStatus memberStatus3 = x2.status();
                MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                if (!(memberStatus3 != null ? !memberStatus3.equals(memberStatus$Up$) : memberStatus$Up$ != null)) {
                    return true;
                }
                MemberStatus memberStatus4 = x2.status();
                MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
                if (!(memberStatus4 != null ? !memberStatus4.equals(memberStatus$Leaving$) : memberStatus$Leaving$ != null)) {
                    return true;
                }
                MemberStatus memberStatus5 = x2.status();
                MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                if (!(memberStatus5 != null ? !memberStatus5.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null)) {
                    return true;
                }
                MemberStatus memberStatus6 = x2.status();
                MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                if (!(memberStatus6 != null ? !memberStatus6.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                    return true;
                }
                MemberStatus memberStatus7 = x2.status();
                MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
                if (!(memberStatus7 != null ? !memberStatus7.equals(memberStatus$PreparingForShutdown$) : memberStatus$PreparingForShutdown$ != null)) {
                    return true;
                }
                MemberStatus memberStatus8 = x2.status();
                MemberStatus$ReadyForShutdown$ memberStatus$ReadyForShutdown$ = MemberStatus$ReadyForShutdown$.MODULE$;
                return !(memberStatus8 != null ? !memberStatus8.equals(memberStatus$ReadyForShutdown$) : memberStatus$ReadyForShutdown$ != null);
            }
        }, Set$.MODULE$.canBuildFrom());
        SortedSet removedMembers = (SortedSet)oldGossip.members().diff(newGossip.members());
        Set removedEvents = (Set)package.ImmutableSortedSetOps$.MODULE$.unsorted$extension(package$.MODULE$.ImmutableSortedSetOps(removedMembers)).map((Function1 & Serializable & scala.Serializable)m -> new ClusterEvent.MemberRemoved(m.copy(MemberStatus$Removed$.MODULE$), m.status()), Set$.MODULE$.canBuildFrom());
        return new VectorBuilder().$plus$plus$eq((TraversableOnce)removedEvents).$plus$plus$eq((TraversableOnce)memberEvents).result();
    }

    @InternalApi
    public Seq<ClusterEvent.LeaderChanged> diffLeader(MembershipState oldState, MembershipState newState) {
        Option<UniqueAddress> newLeader;
        Option<UniqueAddress> option = newLeader = newState.leader();
        Option<UniqueAddress> option2 = oldState.leader();
        if (option == null ? option2 != null : !option.equals(option2)) {
            return new .colon.colon((Object)new ClusterEvent.LeaderChanged((Option<Address>)newLeader.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.address())), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    @InternalApi
    public Set<ClusterEvent.RoleLeaderChanged> diffRolesLeader(MembershipState oldState, MembershipState newState) {
        return (Set)((TraversableLike)oldState.latestGossip().allRoles().union(newState.latestGossip().allRoles()).map((Function1 & Serializable & scala.Serializable)role -> {
            Option<UniqueAddress> newLeader = newState.roleLeader((String)role);
            return new Tuple2(role, newLeader);
        }, Set$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.$anonfun$diffRolesLeader$2(oldState, x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> {
            if (x$7 != null) {
                String role = (String)x$7._1();
                Option newLeader = (Option)x$7._2();
                return new ClusterEvent.RoleLeaderChanged(role, (Option<Address>)newLeader.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.address()));
            }
            throw new MatchError(null);
        }, Set$.MODULE$.canBuildFrom());
    }

    @InternalApi
    public Seq<ClusterEvent.SeenChanged> diffSeen(MembershipState oldState, MembershipState newState) {
        block5: {
            Set<UniqueAddress> newSeenBy;
            boolean newConvergence;
            block4: {
                if (oldState == newState) {
                    return Nil$.MODULE$;
                }
                newConvergence = newState.convergence((Set<UniqueAddress>)Predef$.MODULE$.Set().empty());
                newSeenBy = newState.latestGossip().seenBy();
                if (newConvergence != oldState.convergence((Set<UniqueAddress>)Predef$.MODULE$.Set().empty())) break block4;
                Set<UniqueAddress> set = newSeenBy;
                Set<UniqueAddress> set2 = oldState.latestGossip().seenBy();
                if (!(set == null ? set2 != null : !set.equals(set2))) break block5;
            }
            return new .colon.colon((Object)new ClusterEvent.SeenChanged(newConvergence, (Set<Address>)((Set)newSeenBy.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.address(), Set$.MODULE$.canBuildFrom()))), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    @InternalApi
    public Seq<ClusterEvent.ReachabilityChanged> diffReachability(MembershipState oldState, MembershipState newState) {
        if (newState.overview().reachability() == oldState.overview().reachability()) {
            return Nil$.MODULE$;
        }
        return new .colon.colon((Object)new ClusterEvent.ReachabilityChanged(newState.overview().reachability()), (List)Nil$.MODULE$);
    }

    @InternalApi
    public Seq<ClusterEvent.MemberTombstonesChanged> diffTombstones(MembershipState oldState, MembershipState newState) {
        Map<UniqueAddress, Object> map = newState.latestGossip().tombstones();
        Map<UniqueAddress, Object> map2 = oldState.latestGossip().tombstones();
        if (!(map != null ? !map.equals(map2) : map2 != null)) {
            return Nil$.MODULE$;
        }
        ClusterEvent.MemberTombstonesChanged memberTombstonesChanged = new ClusterEvent.MemberTombstonesChanged((Set<UniqueAddress>)newState.latestGossip().tombstones().keySet());
        return Nil$.MODULE$.$colon$colon((Object)memberTombstonesChanged);
    }

    @InternalApi
    public void publishDiff(MembershipState oldState, MembershipState newState, Function1<Object, BoxedUnit> pub) {
        this.diffTombstones(oldState, newState).foreach(pub);
        this.diffMemberEvents(oldState, newState).foreach(pub);
        this.diffUnreachable(oldState, newState).foreach(pub);
        this.diffReachable(oldState, newState).foreach(pub);
        this.diffUnreachableDataCenter(oldState, newState).foreach(pub);
        this.diffReachableDataCenter(oldState, newState).foreach(pub);
        this.diffLeader(oldState, newState).foreach(pub);
        this.diffRolesLeader(oldState, newState).foreach(pub);
        this.diffSeen(oldState, newState).foreach(pub);
        this.diffReachability(oldState, newState).foreach(pub);
    }

    public static final /* synthetic */ boolean $anonfun$diffRolesLeader$2(MembershipState oldState$3, Tuple2 x$6) {
        if (x$6 != null) {
            String role = (String)x$6._1();
            Option option = (Option)x$6._2();
            Option<UniqueAddress> option2 = oldState$3.roleLeader(role);
            return option == null ? option2 != null : !option.equals(option2);
        }
        throw new MatchError(null);
    }

    private ClusterEvent$() {
        MODULE$ = this;
    }
}

