/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.io.stream;

import cn.sliew.milky.common.io.stream.StreamInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamStreamInput
extends StreamInput {
    private final InputStream is;

    public InputStreamStreamInput(InputStream is) {
        this.is = is;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.is.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int read = this.readFully(this.is, b, offset, len);
        if (read != len) {
            throw new EOFException();
        }
    }

    private int readFully(InputStream reader, byte[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }
}

