/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.convert;

import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.carp.framework.dag.repository.entity.DagLink;
import cn.sliew.carp.framework.dag.service.dto.DagConfigLinkDTO;
import cn.sliew.carp.framework.dag.service.dto.DagLinkDTO;
import cn.sliew.milky.common.util.JacksonUtil;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface DagLinkConvert
extends BaseConvert<DagLink, DagLinkDTO> {
    public static final DagLinkConvert INSTANCE = (DagLinkConvert)Mappers.getMapper(DagLinkConvert.class);

    default public DagLink toDo(DagLinkDTO dto) {
        DagLink entity = new DagLink();
        BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        if (dto.getDagConfigLink() != null) {
            entity.setDagConfigLinkId(dto.getDagConfigLink().getId());
        }
        if (dto.getInputs() != null) {
            entity.setInputs(dto.getInputs().toString());
        }
        if (dto.getOutputs() != null) {
            entity.setOutputs(dto.getOutputs().toString());
        }
        return entity;
    }

    default public DagLinkDTO toDto(DagLink entity) {
        DagLinkDTO dto = new DagLinkDTO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        DagConfigLinkDTO dagConfigLink = new DagConfigLinkDTO();
        dagConfigLink.setId(entity.getDagConfigLinkId());
        dto.setDagConfigLink(dagConfigLink);
        if (StringUtils.hasText((String)entity.getInputs())) {
            dto.setInputs(JacksonUtil.toJsonNode((String)entity.getInputs()));
        }
        if (StringUtils.hasText((String)entity.getOutputs())) {
            dto.setOutputs(JacksonUtil.toJsonNode((String)entity.getOutputs()));
        }
        return dto;
    }
}

