/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.convert.orca;

import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.carp.framework.dag.repository.entity.orca.CarpDagOrcaPipeline;
import cn.sliew.carp.framework.dag.service.convert.orca.CarpDagOrcaPipelineStageConvert;
import cn.sliew.carp.framework.dag.service.dto.orca.CarpDagOrcaPipelineDTO;
import cn.sliew.milky.common.util.JacksonUtil;
import java.time.Instant;
import java.util.Objects;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface CarpDagOrcaPipelineConvert
extends BaseConvert<CarpDagOrcaPipeline, CarpDagOrcaPipelineDTO> {
    public static final CarpDagOrcaPipelineConvert INSTANCE = (CarpDagOrcaPipelineConvert)Mappers.getMapper(CarpDagOrcaPipelineConvert.class);

    default public CarpDagOrcaPipeline toDo(CarpDagOrcaPipelineDTO dto) {
        CarpDagOrcaPipeline entity = new CarpDagOrcaPipeline();
        BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        if (Objects.nonNull(dto.getBuildTime())) {
            entity.setBuildTime(dto.getBuildTime().toEpochMilli());
        }
        if (Objects.nonNull(dto.getStartTime())) {
            entity.setStartTime(dto.getStartTime().toEpochMilli());
        }
        if (Objects.nonNull(dto.getEndTime())) {
            entity.setEndTime(dto.getEndTime().toEpochMilli());
        }
        if (Objects.nonNull(dto.getBody())) {
            entity.setBody(dto.getBody().toString());
        }
        if (!CollectionUtils.isEmpty(dto.getStages())) {
            entity.setStages(CarpDagOrcaPipelineStageConvert.INSTANCE.toDo(dto.getStages()));
        }
        return entity;
    }

    default public CarpDagOrcaPipelineDTO toDto(CarpDagOrcaPipeline entity) {
        CarpDagOrcaPipelineDTO dto = new CarpDagOrcaPipelineDTO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        if (Objects.nonNull(entity.getBuildTime())) {
            dto.setBuildTime(Instant.ofEpochMilli(entity.getBuildTime()));
        }
        if (Objects.nonNull(entity.getStartTime())) {
            dto.setStartTime(Instant.ofEpochMilli(entity.getStartTime()));
        }
        if (Objects.nonNull(entity.getEndTime())) {
            dto.setEndTime(Instant.ofEpochMilli(entity.getEndTime()));
        }
        if (StringUtils.hasText((String)entity.getBody())) {
            dto.setBody(JacksonUtil.toJsonNode((String)entity.getBody()));
        }
        if (!CollectionUtils.isEmpty(entity.getStages())) {
            dto.setStages(CarpDagOrcaPipelineStageConvert.INSTANCE.toDto(entity.getStages()));
        }
        return dto;
    }
}

