/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.impl;

import cn.sliew.carp.framework.common.util.UUIDUtil;
import cn.sliew.carp.framework.dag.algorithm.DAG;
import cn.sliew.carp.framework.dag.algorithm.DefaultDagEdge;
import cn.sliew.carp.framework.dag.service.DagConfigComplexService;
import cn.sliew.carp.framework.dag.service.DagInstanceComplexService;
import cn.sliew.carp.framework.dag.service.DagInstanceService;
import cn.sliew.carp.framework.dag.service.DagLinkService;
import cn.sliew.carp.framework.dag.service.DagStepService;
import cn.sliew.carp.framework.dag.service.dto.DagConfigComplexDTO;
import cn.sliew.carp.framework.dag.service.dto.DagConfigLinkDTO;
import cn.sliew.carp.framework.dag.service.dto.DagConfigStepDTO;
import cn.sliew.carp.framework.dag.service.dto.DagInstanceComplexDTO;
import cn.sliew.carp.framework.dag.service.dto.DagInstanceDTO;
import cn.sliew.carp.framework.dag.service.dto.DagLinkDTO;
import cn.sliew.carp.framework.dag.service.dto.DagStepDTO;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DagInstanceComplexServiceImpl
implements DagInstanceComplexService {
    @Autowired
    private DagConfigComplexService dagConfigComplexService;
    @Autowired
    private DagInstanceService dagInstanceService;
    @Autowired
    private DagLinkService dagLinkService;
    @Autowired
    private DagStepService dagStepService;

    @Override
    public DagInstanceComplexDTO selectOne(Long dagInstanceId) {
        DagInstanceComplexDTO dagInstanceComplexDTO = new DagInstanceComplexDTO();
        DagInstanceDTO instanceDTO = this.dagInstanceService.get(dagInstanceId);
        BeanUtils.copyProperties((Object)((Object)instanceDTO), (Object)((Object)dagInstanceComplexDTO));
        dagInstanceComplexDTO.setLinks(this.dagLinkService.listLinks(dagInstanceId));
        dagInstanceComplexDTO.setSteps(this.dagStepService.listSteps(dagInstanceId));
        return dagInstanceComplexDTO;
    }

    @Override
    public DagInstanceDTO selectSimpleOne(Long dagInstanceId) {
        return this.dagInstanceService.get(dagInstanceId);
    }

    @Override
    public Graph<DagStepDTO> getDag(Long dagInstanceId, Graph<DagConfigStepDTO> configDag) {
        DAG<DagStepDTO> dag = this.getDagNew(dagInstanceId);
        MutableGraph graph = GraphBuilder.directed().build();
        dag.nodes().forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        dag.edges().forEach(edge -> graph.putEdge((Object)((DagStepDTO)((Object)((Object)edge.getSource()))), (Object)((DagStepDTO)((Object)((Object)edge.getTarget())))));
        return graph;
    }

    @Override
    public DAG<DagStepDTO> getDagNew(Long dagInstanceId) {
        DagInstanceComplexDTO dagInstanceComplexDTO = this.selectOne(dagInstanceId);
        DAG<DagConfigStepDTO> configGraph = this.dagConfigComplexService.getDagNew(dagInstanceComplexDTO.getDagConfig().getId());
        DAG<DagStepDTO> graph = new DAG<DagStepDTO>();
        HashMap<Long, DagStepDTO> stepMap = new HashMap<Long, DagStepDTO>();
        for (DagStepDTO dagStepDTO : dagInstanceComplexDTO.getSteps()) {
            stepMap.put(dagStepDTO.getDagConfigStep().getId(), dagStepDTO);
            graph.addNode(dagStepDTO);
        }
        for (DefaultDagEdge defaultDagEdge : configGraph.edges()) {
            DagConfigStepDTO source = (DagConfigStepDTO)((Object)defaultDagEdge.getSource());
            DagConfigStepDTO target = (DagConfigStepDTO)((Object)defaultDagEdge.getTarget());
            graph.addEdge((DagStepDTO)((Object)stepMap.get(source.getId())), (DagStepDTO)((Object)stepMap.get(target.getId())));
        }
        return graph;
    }

    @Override
    public Long initialize(Long dagConfigId) {
        DagConfigComplexDTO dagConfigComplexDTO = this.dagConfigComplexService.selectOne(dagConfigId);
        DagInstanceDTO dagInstanceDTO = new DagInstanceDTO();
        dagInstanceDTO.setDagConfig(dagConfigComplexDTO);
        dagInstanceDTO.setUuid(UUIDUtil.randomUUId());
        dagInstanceDTO.setStartTime(new Date());
        Long dagInstanceId = this.dagInstanceService.add(dagInstanceDTO);
        if (!CollectionUtils.isEmpty(dagConfigComplexDTO.getSteps())) {
            for (DagConfigStepDTO dagConfigStepDTO : dagConfigComplexDTO.getSteps()) {
                DagStepDTO dagStepDTO = new DagStepDTO();
                dagStepDTO.setDagInstanceId(dagInstanceId);
                dagStepDTO.setDagConfigStep(dagConfigStepDTO);
                dagStepDTO.setUuid(UUIDUtil.randomUUId());
                dagStepDTO.setStartTime(new Date());
                this.dagStepService.add(dagStepDTO);
            }
        }
        if (!CollectionUtils.isEmpty(dagConfigComplexDTO.getLinks())) {
            for (DagConfigLinkDTO dagConfigLinkDTO : dagConfigComplexDTO.getLinks()) {
                DagLinkDTO dagLinkDTO = new DagLinkDTO();
                dagLinkDTO.setDagInstanceId(dagInstanceId);
                dagLinkDTO.setDagConfigLink(dagConfigLinkDTO);
                dagLinkDTO.setUuid(UUIDUtil.randomUUId());
                dagLinkDTO.setInputs(dagConfigLinkDTO.getLinkAttrs());
                dagLinkDTO.setStartTime(new Date());
                this.dagLinkService.add(dagLinkDTO);
            }
        }
        return dagInstanceId;
    }
}

