/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.impl;

import cn.sliew.carp.framework.common.util.UUIDUtil;
import cn.sliew.carp.framework.dag.repository.entity.DagStep;
import cn.sliew.carp.framework.dag.repository.entity.DagStepVO;
import cn.sliew.carp.framework.dag.repository.mapper.DagStepMapper;
import cn.sliew.carp.framework.dag.service.DagStepService;
import cn.sliew.carp.framework.dag.service.convert.DagStepConvert;
import cn.sliew.carp.framework.dag.service.convert.DagStepVOConvert;
import cn.sliew.carp.framework.dag.service.dto.DagStepDTO;
import cn.sliew.carp.framework.mybatis.entity.BaseDO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DagStepServiceImpl
extends ServiceImpl<DagStepMapper, DagStep>
implements DagStepService {
    @Override
    public List<DagStepDTO> listSteps(Long dagInstanceId) {
        List<DagStepVO> dagStepVOS = ((DagStepMapper)this.baseMapper).listByDagInstanceId(dagInstanceId);
        return DagStepVOConvert.INSTANCE.toDto(dagStepVOS);
    }

    @Override
    public DagStepDTO get(Long id) {
        DagStep entity = (DagStep)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("dag step not exists for id: " + id)));
        return DagStepConvert.INSTANCE.toDto(entity);
    }

    @Override
    public boolean add(DagStepDTO stepDTO) {
        DagStep record = DagStepConvert.INSTANCE.toDo(stepDTO);
        record.setUuid(UUIDUtil.randomUUId());
        return this.save((Object)record);
    }

    @Override
    public boolean update(DagStepDTO stepDTO) {
        DagStep record = DagStepConvert.INSTANCE.toDo(stepDTO);
        return this.updateById((Object)record);
    }

    @Override
    public boolean updateStatus(Long id, String fromStatus, String toStatus) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagStep.class).eq(BaseDO::getId, (Object)id)).eq(StringUtils.hasText((String)fromStatus), DagStep::getStatus, (Object)fromStatus)).set(DagStep::getStatus, (Object)toStatus);
        return this.update((Wrapper)wrapper);
    }
}

