/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.executor.api.executor;

import cn.sliew.carp.framework.common.dict.schedule.CarpScheduleEngineType;
import cn.sliew.carp.framework.common.dict.schedule.CarpScheduleJobType;
import cn.sliew.carp.module.scheduler.executor.api.dict.CarpScheduleExecuteType;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobExecutor;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobExecutorManager;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class DefaultJobexecutorManager
implements JobExecutorManager {
    private List<JobExecutor> executors;

    public DefaultJobexecutorManager(List<JobExecutor> executors) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(executors), (Object)"executors not allowed empty");
        this.executors = executors;
    }

    @Override
    public List<CarpScheduleEngineType> listEngines() {
        return Arrays.asList(CarpScheduleEngineType.values());
    }

    @Override
    public Set<CarpScheduleJobType> listTypes(CarpScheduleEngineType engineType) {
        return this.executors.stream().filter(executor -> CollectionUtils.containsAny(executor.getEngines(), (Object[])new CarpScheduleEngineType[]{engineType})).map(JobExecutor::getType).collect(Collectors.toSet());
    }

    @Override
    public List<CarpScheduleExecuteType> listExecutorTypes(CarpScheduleEngineType engineType, CarpScheduleJobType jobType) {
        return Optional.of(this.getExecutor(engineType, jobType)).map(JobExecutor::getSupportExecuteTypes).orElseThrow();
    }

    @Override
    public JobExecutor getExecutor(CarpScheduleEngineType engineType, CarpScheduleJobType jobType) {
        return this.executors.stream().filter(executor -> CollectionUtils.containsAny(executor.getEngines(), (Object[])new CarpScheduleEngineType[]{engineType})).filter(executor -> Objects.equals(executor.getType(), jobType)).findFirst().orElseThrow();
    }
}

