/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import jodd.util.CharUtil;

public class CharSequenceUtil {
    public static boolean equals(CharSequence charSequence1, CharSequence charSequence2) {
        int len = charSequence1.length();
        if (len != charSequence2.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (charSequence1.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsToLowercase(CharSequence charSequence, CharSequence name) {
        int len = charSequence.length();
        if (len != name.length()) {
            return false;
        }
        return !CharSequenceUtil.compare(charSequence, name, len);
    }

    public static boolean startsWithLowercase(CharSequence charSequence, CharSequence chars) {
        int length = chars.length();
        if (charSequence.length() < length) {
            return false;
        }
        return !CharSequenceUtil.compare(charSequence, chars, length);
    }

    private static boolean compare(CharSequence charSequence, CharSequence chars, int length) {
        for (int i = 0; i < length; ++i) {
            char c = charSequence.charAt(i);
            if ((c = CharUtil.toLowerAscii(c)) == chars.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(CharSequence charSequence1, CharSequence charSequence2) {
        int len = charSequence1.length();
        if (len != charSequence2.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c1 = charSequence1.charAt(i);
            c1 = CharUtil.toLowerAscii(c1);
            char c2 = charSequence2.charAt(i);
            if (c1 == (c2 = CharUtil.toLowerAscii(c2))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsOne(char c, CharSequence match) {
        for (int i = 0; i < match.length(); ++i) {
            char aMatch = match.charAt(i);
            if (c != aMatch) continue;
            return true;
        }
        return false;
    }

    public static int findFirstEqual(CharSequence source, int index, CharSequence match) {
        for (int i = index; i < source.length(); ++i) {
            if (!CharSequenceUtil.equalsOne(source.charAt(i), match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstEqual(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] != match) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(CharSequence source, int index, CharSequence match) {
        for (int i = index; i < source.length(); ++i) {
            if (CharSequenceUtil.equalsOne(source.charAt(i), match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] == match) continue;
            return i;
        }
        return -1;
    }
}

