/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.dict;

import cn.hutool.core.util.ArrayUtil;
import cn.sliew.carp.framework.common.dict.CarpDictType;
import cn.sliew.carp.framework.common.dict.DictDefinition;
import cn.sliew.carp.framework.common.dict.DictInstance;
import cn.sliew.carp.framework.common.dict.DictRegistry;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;

public enum CarpEnumDictRegistry implements DictRegistry
{
    INSTANCE;

    private static final Table<DictDefinition, String, DictInstance> DICT_TABLE;

    public static void register(DictDefinition definition, List<DictInstance> instances) {
        if (ArrayUtil.isNotEmpty(instances)) {
            for (DictInstance instance : instances) {
                DICT_TABLE.put((Object)definition, (Object)instance.getValue(), (Object)instance);
            }
        }
    }

    @Override
    public Collection<DictDefinition> getAllDefinitions() {
        return DICT_TABLE.rowKeySet();
    }

    @Override
    public Optional<DictDefinition> getDictDefinition(String code) {
        return this.getAllDefinitions().stream().filter(dictDefinition -> dictDefinition.getCode().equals(code)).findFirst();
    }

    @Override
    public Collection<DictInstance> getAllInstances() {
        return DICT_TABLE.values();
    }

    @Override
    public Collection<DictInstance> getDictInstance(DictDefinition definition) {
        return DICT_TABLE.row((Object)definition).values();
    }

    @Override
    public boolean exists(DictDefinition definition, String instanceName) {
        return DICT_TABLE.contains(DICT_TABLE, (Object)instanceName);
    }

    @Override
    public Optional<DictInstance> getDictInstance(DictDefinition definition, String instanceName) {
        return Optional.ofNullable((DictInstance)DICT_TABLE.get((Object)definition, (Object)instanceName));
    }

    static {
        DICT_TABLE = HashBasedTable.create();
        List enumList = EnumUtils.getEnumList(CarpDictType.class);
        for (CarpDictType dictType : enumList) {
            List values = EnumUtils.getEnumList((Class)dictType.getInstanceClass());
            CarpEnumDictRegistry.register(dictType, values);
        }
    }
}

