/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.dict.workflow;

import cn.sliew.carp.framework.common.dict.DictInstance;
import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Arrays;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum CarpWorkflowTaskInstanceStage implements DictInstance
{
    PENDING("0", "PENDING"),
    RUNNING("1", "RUNNING"),
    SUSPEND("3", "SUSPEND"),
    SUCCESS("4", "SUCCESS"),
    FAILURE("5", "FAILURE"),
    TERMINATED("6", "TERMINATED");

    @EnumValue
    private String value;
    private String label;

    @JsonCreator
    public static CarpWorkflowTaskInstanceStage of(String value) {
        return Arrays.stream(CarpWorkflowTaskInstanceStage.values()).filter(instance -> instance.getValue().equals(value)).findAny().orElseThrow(() -> new EnumConstantNotPresentException(CarpWorkflowTaskInstanceStage.class, value));
    }

    private CarpWorkflowTaskInstanceStage(String value, String label) {
        this.value = value;
        this.label = label;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isEnd() {
        switch (this) {
            case SUCCESS: 
            case FAILURE: 
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    public boolean isSuccess() {
        switch (this) {
            case SUCCESS: {
                return true;
            }
        }
        return false;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }
}

