/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.model;

import cn.sliew.carp.framework.common.model.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

@Schema(description="\u5206\u9875\u7ed3\u679c")
public class PageResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u5f53\u524d\u9875\u6570", example="1")
    private Long current = 1L;
    @Schema(description="\u6bcf\u9875\u6761\u6570", example="10")
    private Long size = 10L;
    @Schema(description="\u6570\u636e\u603b\u6570", example="10")
    private Long total;
    @Schema(description="\u6570\u636e")
    private List<T> records;

    public PageResult(Long current, Long size, Long total) {
        this.current = current;
        this.size = size;
        this.total = total;
    }

    public static PageResult build(List records, PageParam pageParam) {
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new PageResult(pageParam.getCurrent(), pageParam.getPageSize(), 0L);
        }
        PageResult pageResult = new PageResult(pageParam.getCurrent(), pageParam.getPageSize(), Long.valueOf(records.size()));
        Long from = (pageParam.getCurrent() - 1L) * pageParam.getPageSize();
        Long last = pageParam.getCurrent() * pageParam.getPageSize() <= (long)records.size() ? pageParam.getCurrent() * pageParam.getPageSize() : (long)records.size();
        pageResult.setRecords(records.subList(from.intValue(), last.intValue()));
        return pageResult;
    }

    @Generated
    public Long getCurrent() {
        return this.current;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public Long getTotal() {
        return this.total;
    }

    @Generated
    public List<T> getRecords() {
        return this.records;
    }

    @Generated
    public void setCurrent(Long current) {
        this.current = current;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setTotal(Long total) {
        this.total = total;
    }

    @Generated
    public void setRecords(List<T> records) {
        this.records = records;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$current = this.getCurrent();
        Long other$current = other.getCurrent();
        if (this$current == null ? other$current != null : !((Object)this$current).equals(other$current)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        List<T> this$records = this.getRecords();
        List<T> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $current = this.getCurrent();
        result = result * 59 + ($current == null ? 43 : ((Object)$current).hashCode());
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        List<T> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageResult(current=" + this.getCurrent() + ", size=" + this.getSize() + ", total=" + this.getTotal() + ", records=" + String.valueOf(this.getRecords()) + ")";
    }

    @Generated
    public PageResult() {
    }

    @Generated
    public PageResult(Long current, Long size, Long total, List<T> records) {
        this.current = current;
        this.size = size;
        this.total = total;
        this.records = records;
    }
}

