/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.reflection;

import cn.sliew.carp.framework.common.reflection.JobDetails;
import cn.sliew.carp.framework.common.reflection.JobDetailsBuilder;
import cn.sliew.carp.framework.common.reflection.instructions.AllJVMInstructions;
import cn.sliew.carp.framework.common.reflection.instructions.InvokeDynamicInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.LdcInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.SingleIntOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.VisitFieldInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.VisitLocalVariableInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.VisitMethodInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.VisitTypeInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.ZeroOperandInstruction;
import cn.sliew.carp.framework.common.reflection.lambdas.JobRunrJob;
import cn.sliew.carp.framework.common.util.reflection.JarUtils;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

abstract class AbstractJobDetailsFinder
extends ClassVisitor {
    protected final JobDetailsBuilder jobDetailsBuilder;

    protected AbstractJobDetailsFinder(JobDetailsBuilder jobDetailsBuilder) {
        super(458752);
        this.jobDetailsBuilder = jobDetailsBuilder;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.isLambdaContainingJobDetails(name)) {
            return new MethodVisitor(458752){

                public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                    VisitFieldInstruction instruction = (VisitFieldInstruction)AllJVMInstructions.get(opcode, AbstractJobDetailsFinder.this.jobDetailsBuilder);
                    instruction.load(owner, name, descriptor);
                }

                public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                    InvokeDynamicInstruction instruction = (InvokeDynamicInstruction)AllJVMInstructions.get(186, AbstractJobDetailsFinder.this.jobDetailsBuilder);
                    instruction.load(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                    VisitMethodInstruction visitMethodInstruction = (VisitMethodInstruction)AllJVMInstructions.get(opcode, AbstractJobDetailsFinder.this.jobDetailsBuilder);
                    visitMethodInstruction.load(owner, name, descriptor, isInterface);
                }

                public void visitInsn(int opcode) {
                    ZeroOperandInstruction zeroOperandInstruction = (ZeroOperandInstruction)AllJVMInstructions.get(opcode, AbstractJobDetailsFinder.this.jobDetailsBuilder);
                    zeroOperandInstruction.load();
                }

                public void visitVarInsn(int opcode, int variable) {
                    VisitLocalVariableInstruction instruction = (VisitLocalVariableInstruction)AllJVMInstructions.get(opcode, AbstractJobDetailsFinder.this.jobDetailsBuilder);
                    instruction.load(variable);
                }

                public void visitIntInsn(int opcode, int operand) {
                    SingleIntOperandInstruction singleIntOperandInstruction = (SingleIntOperandInstruction)AllJVMInstructions.get(opcode, AbstractJobDetailsFinder.this.jobDetailsBuilder);
                    singleIntOperandInstruction.load(operand);
                }

                public void visitLdcInsn(Object value) {
                    LdcInstruction ldcInstruction = (LdcInstruction)AllJVMInstructions.get(18, AbstractJobDetailsFinder.this.jobDetailsBuilder);
                    ldcInstruction.load(value);
                }

                public void visitTypeInsn(int opcode, String type) {
                    VisitTypeInstruction instruction = (VisitTypeInstruction)AllJVMInstructions.get(opcode, AbstractJobDetailsFinder.this.jobDetailsBuilder);
                    instruction.load(type);
                }
            };
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    protected abstract boolean isLambdaContainingJobDetails(String var1);

    protected abstract InputStream getClassContainingLambdaAsInputStream();

    public JobDetails getJobDetails() {
        return this.jobDetailsBuilder.getJobDetails();
    }

    protected void parse(InputStream inputStream) throws IOException {
        try {
            ClassReader parser = new ClassReader(inputStream);
            parser.accept((ClassVisitor)this, 4);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("Unsupported class file")) {
                String requiredAsmVersion = JarUtils.getManifestAttributeValue(JobRunrJob.class, "Minimum-ASM-Version");
                String actualAsmVersion = JarUtils.getVersion(Opcodes.class);
                throw new IllegalArgumentException("JobRunr needs (and automatically adds) ASM " + requiredAsmVersion + " as a transitive dependency but you have ASM " + actualAsmVersion + " on the classpath.", e);
            }
            throw e;
        }
    }
}

