/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.reflection.instructions;

import cn.sliew.carp.framework.common.reflection.JobDetailsBuilder;
import cn.sliew.carp.framework.common.reflection.JobDetailsGeneratorUtils;
import cn.sliew.carp.framework.common.reflection.instructions.JobDetailsInstruction;
import java.util.List;

public class InvokeStaticInstruction
extends JobDetailsInstruction {
    public InvokeStaticInstruction(JobDetailsBuilder jobDetailsBuilder) {
        super(jobDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        if (this.isKotlinNullCheck()) {
            this.getObject();
            return DO_NOT_PUT_ON_STACK;
        }
        return super.invokeInstruction();
    }

    @Override
    protected Object getObject() {
        Class<?>[] paramTypes = JobDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor);
        List<Object> parameters = this.getParametersUsingParamTypes(paramTypes);
        if (this.isKotlinNullCheck()) {
            return null;
        }
        Object result = JobDetailsGeneratorUtils.createObjectViaStaticMethod(this.getClassName(), this.getMethodName(), paramTypes, parameters.toArray());
        return result;
    }

    private boolean isKotlinNullCheck() {
        return this.getClassName().startsWith("kotlin.") && this.getMethodName().startsWith("checkNotNull");
    }

    @Override
    String getClassName() {
        return JobDetailsGeneratorUtils.toFQClassName(this.owner);
    }
}

