/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.reflection.instructions;

import cn.sliew.carp.framework.common.reflection.JobDetailsBuilder;
import cn.sliew.carp.framework.common.reflection.instructions.AbstractJVMInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.JobDetailsInstruction;
import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class VisitMethodInstruction
extends AbstractJVMInstruction {
    protected String owner;
    protected String name;
    protected String descriptor;
    protected boolean isInterface;

    protected VisitMethodInstruction(JobDetailsBuilder jobDetailsBuilder) {
        super(jobDetailsBuilder);
    }

    public void load(String owner, String name, String descriptor, boolean isInterface) {
        this.owner = owner;
        this.name = name;
        this.descriptor = descriptor;
        this.isInterface = isInterface;
        this.jobDetailsBuilder.pushInstructionOnStack(this);
    }

    protected boolean isVoidInstruction() {
        return this.descriptor.endsWith(")V");
    }

    protected boolean isLastJobDetailsInstruction() {
        return this.jobDetailsBuilder.getInstructions().stream().noneMatch(JobDetailsInstruction.class::isInstance);
    }

    protected List<Object> getParametersUsingParamTypes(Class<?>[] paramTypesAsArray) {
        LinkedList paramTypes = new LinkedList(Arrays.asList(paramTypesAsArray));
        ArrayList<Object> result = new ArrayList<Object>();
        while (!paramTypes.isEmpty()) {
            Class<?> paramType = paramTypes.pollLast();
            result.add(0, ReflectionUtils.autobox(this.jobDetailsBuilder.getStack().pollLast(), paramType));
        }
        return result;
    }
}

