/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.util.reflection;

import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Predicate;

public class MethodFinderPredicate
implements Predicate<Method> {
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public MethodFinderPredicate(String methodName, Class<?> ... parameterTypes) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public boolean test(Method method) {
        if (method.isBridge()) {
            return false;
        }
        return this.methodName.equals(method.getName()) && (Arrays.equals(method.getParameterTypes(), this.parameterTypes) || this.compareParameterTypesForPrimitives(method.getParameterTypes()));
    }

    private boolean compareParameterTypesForPrimitives(Class<?>[] parameterTypes) {
        if (this.parameterTypes.length != parameterTypes.length) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < parameterTypes.length; ++i) {
            result &= ReflectionUtils.isClassAssignable(parameterTypes[i], this.parameterTypes[i]);
        }
        return result;
    }
}

