/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.util.reflection.autobox;

import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import cn.sliew.carp.framework.common.util.reflection.autobox.BooleanTypeAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.DoubleTypeAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.DurationTypeAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.EnumAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.FloatTypeAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.InstantTypeAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.IntegerTypeAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.LongTypeAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.StringTypeAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.TypeAutoboxer;
import cn.sliew.carp.framework.common.util.reflection.autobox.UUIDTypeAutoboxer;
import java.util.Arrays;
import java.util.List;

public final class Autoboxer
extends Enum<Autoboxer> {
    private static final List<TypeAutoboxer> autoboxers;
    private static final /* synthetic */ Autoboxer[] $VALUES;

    public static Autoboxer[] values() {
        return (Autoboxer[])$VALUES.clone();
    }

    public static Autoboxer valueOf(String name) {
        return Enum.valueOf(Autoboxer.class, name);
    }

    public static <T> T autobox(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return ReflectionUtils.cast(value);
        }
        return ReflectionUtils.cast(autoboxers.stream().filter(autoboxer -> autoboxer.supports(type)).findFirst().map(autoboxer -> autoboxer.autobox(value, type)).orElseThrow(() -> new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), type.getName()))));
    }

    private static /* synthetic */ Autoboxer[] $values() {
        return new Autoboxer[0];
    }

    static {
        $VALUES = Autoboxer.$values();
        autoboxers = Arrays.asList(new BooleanTypeAutoboxer(), new InstantTypeAutoboxer(), new IntegerTypeAutoboxer(), new LongTypeAutoboxer(), new DoubleTypeAutoboxer(), new FloatTypeAutoboxer(), new StringTypeAutoboxer(), new UUIDTypeAutoboxer(), new EnumAutoboxer(), new DurationTypeAutoboxer());
    }
}

