/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.util.reflection.autobox;

import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import cn.sliew.carp.framework.common.util.reflection.autobox.TypeAutoboxer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class InstantTypeAutoboxer
implements TypeAutoboxer<Instant> {
    @Override
    public boolean supports(Class<?> type) {
        return Instant.class.equals(type);
    }

    @Override
    public Instant autobox(Object value, Class<Instant> type) {
        if (value instanceof Timestamp) {
            return (Instant)ReflectionUtils.cast(((Timestamp)value).toInstant());
        }
        if (value instanceof Long) {
            return (Instant)ReflectionUtils.cast(new Timestamp((Long)value).toInstant());
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant();
        }
        if (value instanceof CharSequence) {
            return Instant.parse((CharSequence)value);
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Instant.class.getName()));
    }
}

