/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.mapper;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MapperScannerConfigurer
implements BeanDefinitionRegistryPostProcessor,
InitializingBean,
ApplicationContextAware,
BeanNameAware {
    private String basePackage;
    private boolean addToConfig = true;
    private String lazyInitialization;
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;
    private String sqlSessionFactoryBeanName;
    private String sqlSessionTemplateBeanName;
    private Class<? extends Annotation> annotationClass;
    private Class<?> markerInterface;
    private List<TypeFilter> excludeFilters;
    private List<Map<String, String>> rawExcludeFilters;
    private Class<? extends MapperFactoryBean> mapperFactoryBeanClass;
    private ApplicationContext applicationContext;
    private String beanName;
    private boolean processPropertyPlaceHolders;
    private BeanNameGenerator nameGenerator;
    private String defaultScope;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public void setLazyInitialization(String lazyInitialization) {
        this.lazyInitialization = lazyInitialization;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void setMarkerInterface(Class<?> superClass) {
        this.markerInterface = superClass;
    }

    public void setExcludeFilters(List<TypeFilter> excludeFilters) {
        this.excludeFilters = excludeFilters;
    }

    public void setRawExcludeFilters(List<Map<String, String>> rawExcludeFilters) {
        this.rawExcludeFilters = rawExcludeFilters;
    }

    @Deprecated
    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    public void setSqlSessionTemplateBeanName(String sqlSessionTemplateName) {
        this.sqlSessionTemplateBeanName = sqlSessionTemplateName;
    }

    @Deprecated
    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setSqlSessionFactoryBeanName(String sqlSessionFactoryName) {
        this.sqlSessionFactoryBeanName = sqlSessionFactoryName;
    }

    public void setProcessPropertyPlaceHolders(boolean processPropertyPlaceHolders) {
        this.processPropertyPlaceHolders = processPropertyPlaceHolders;
    }

    public void setMapperFactoryBeanClass(Class<? extends MapperFactoryBean> mapperFactoryBeanClass) {
        this.mapperFactoryBeanClass = mapperFactoryBeanClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public BeanNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public void setNameGenerator(BeanNameGenerator nameGenerator) {
        this.nameGenerator = nameGenerator;
    }

    public void setDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.basePackage, (String)"Property 'basePackage' is required");
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        if (this.processPropertyPlaceHolders) {
            this.processPropertyPlaceHolders();
        }
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry, this.getEnvironment());
        scanner.setAddToConfig(this.addToConfig);
        scanner.setAnnotationClass(this.annotationClass);
        scanner.setMarkerInterface(this.markerInterface);
        this.excludeFilters = this.mergeExcludeFilters();
        scanner.setExcludeFilters(this.excludeFilters);
        scanner.setSqlSessionFactory(this.sqlSessionFactory);
        scanner.setSqlSessionTemplate(this.sqlSessionTemplate);
        scanner.setSqlSessionFactoryBeanName(this.sqlSessionFactoryBeanName);
        scanner.setSqlSessionTemplateBeanName(this.sqlSessionTemplateBeanName);
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        scanner.setBeanNameGenerator(this.nameGenerator);
        scanner.setMapperFactoryBeanClass(this.mapperFactoryBeanClass);
        if (StringUtils.hasText((String)this.lazyInitialization)) {
            scanner.setLazyInitialization(Boolean.parseBoolean(this.lazyInitialization));
        }
        if (StringUtils.hasText((String)this.defaultScope)) {
            scanner.setDefaultScope(this.defaultScope);
        }
        scanner.registerFilters();
        scanner.scan(StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n"));
    }

    private void processPropertyPlaceHolders() {
        Map prcs = this.applicationContext.getBeansOfType(PropertyResourceConfigurer.class, false, false);
        if (!prcs.isEmpty() && this.applicationContext instanceof ConfigurableApplicationContext) {
            BeanDefinition mapperScannerBean = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getBeanDefinition(this.beanName);
            DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
            factory.registerBeanDefinition(this.beanName, mapperScannerBean);
            for (PropertyResourceConfigurer prc : prcs.values()) {
                prc.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
            }
            MutablePropertyValues values = mapperScannerBean.getPropertyValues();
            this.basePackage = this.getPropertyValue("basePackage", (PropertyValues)values);
            this.sqlSessionFactoryBeanName = this.getPropertyValue("sqlSessionFactoryBeanName", (PropertyValues)values);
            this.sqlSessionTemplateBeanName = this.getPropertyValue("sqlSessionTemplateBeanName", (PropertyValues)values);
            this.lazyInitialization = this.getPropertyValue("lazyInitialization", (PropertyValues)values);
            this.defaultScope = this.getPropertyValue("defaultScope", (PropertyValues)values);
            this.rawExcludeFilters = this.getPropertyValueForTypeFilter("rawExcludeFilters", (PropertyValues)values);
        }
        this.basePackage = Optional.ofNullable(this.basePackage).map(arg_0 -> ((Environment)this.getEnvironment()).resolvePlaceholders(arg_0)).orElse(null);
        this.sqlSessionFactoryBeanName = Optional.ofNullable(this.sqlSessionFactoryBeanName).map(arg_0 -> ((Environment)this.getEnvironment()).resolvePlaceholders(arg_0)).orElse(null);
        this.sqlSessionTemplateBeanName = Optional.ofNullable(this.sqlSessionTemplateBeanName).map(arg_0 -> ((Environment)this.getEnvironment()).resolvePlaceholders(arg_0)).orElse(null);
        this.lazyInitialization = Optional.ofNullable(this.lazyInitialization).map(arg_0 -> ((Environment)this.getEnvironment()).resolvePlaceholders(arg_0)).orElse(null);
        this.defaultScope = Optional.ofNullable(this.defaultScope).map(arg_0 -> ((Environment)this.getEnvironment()).resolvePlaceholders(arg_0)).orElse(null);
    }

    private Environment getEnvironment() {
        return this.applicationContext.getEnvironment();
    }

    private String getPropertyValue(String propertyName, PropertyValues values) {
        PropertyValue property = values.getPropertyValue(propertyName);
        if (property == null) {
            return null;
        }
        Object value = property.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof TypedStringValue) {
            return ((TypedStringValue)value).getValue();
        }
        return null;
    }

    private List<Map<String, String>> getPropertyValueForTypeFilter(String propertyName, PropertyValues values) {
        Object value;
        PropertyValue property = values.getPropertyValue(propertyName);
        if (property == null || (value = property.getValue()) == null || !(value instanceof List)) {
            return null;
        }
        return (List)value;
    }

    private List<TypeFilter> mergeExcludeFilters() {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        if (this.rawExcludeFilters == null || this.rawExcludeFilters.isEmpty()) {
            return this.excludeFilters;
        }
        if (this.excludeFilters != null && !this.excludeFilters.isEmpty()) {
            typeFilters.addAll(this.excludeFilters);
        }
        try {
            for (Map<String, String> typeFilter : this.rawExcludeFilters) {
                typeFilters.add(this.createTypeFilter(typeFilter.get("type"), typeFilter.get("expression"), this.getClass().getClassLoader()));
            }
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException("ClassNotFoundException occur when to load the Specified excludeFilter classes.", exception);
        }
        return typeFilters;
    }

    private TypeFilter createTypeFilter(String filterType, String expression, @Nullable ClassLoader classLoader) throws ClassNotFoundException {
        if (this.processPropertyPlaceHolders) {
            expression = this.getEnvironment().resolvePlaceholders(expression);
        }
        switch (filterType) {
            case "annotation": {
                Class filterAnno = ClassUtils.forName((String)expression, (ClassLoader)classLoader);
                if (!Annotation.class.isAssignableFrom(filterAnno)) {
                    throw new IllegalArgumentException("Class is not assignable to [" + Annotation.class.getName() + "]: " + expression);
                }
                return new AnnotationTypeFilter(filterAnno);
            }
            case "custom": {
                Class filterClass = ClassUtils.forName((String)expression, (ClassLoader)classLoader);
                if (!TypeFilter.class.isAssignableFrom(filterClass)) {
                    throw new IllegalArgumentException("Class is not assignable to [" + TypeFilter.class.getName() + "]: " + expression);
                }
                return (TypeFilter)BeanUtils.instantiateClass((Class)filterClass);
            }
            case "assignable": {
                return new AssignableTypeFilter(ClassUtils.forName((String)expression, (ClassLoader)classLoader));
            }
            case "regex": {
                return new RegexPatternTypeFilter(Pattern.compile(expression));
            }
            case "aspectj": {
                return new AspectJTypeFilter(expression, classLoader);
            }
        }
        throw new IllegalArgumentException("Unsupported filter type: " + filterType);
    }
}

