/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model.processor;

import cn.sliew.carp.framework.spring.util.LogUtil;
import cn.sliew.carp.module.http.sync.framework.model.JobSetting;
import cn.sliew.carp.module.http.sync.framework.model.job.JobInfo;
import cn.sliew.carp.module.http.sync.framework.model.job.JobLogLevel;
import cn.sliew.carp.module.http.sync.framework.model.manager.LockManager;
import cn.sliew.carp.module.http.sync.framework.model.manager.SplitManager;
import cn.sliew.carp.module.http.sync.framework.model.manager.SyncOffsetManager;
import cn.sliew.carp.module.http.sync.framework.model.processor.JobContext;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pekko.actor.typed.ActorSystem;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class DefaultJobContext
implements JobContext {
    private JobSetting setting;
    private ActorSystem actorSystem;
    private MeterRegistry meterRegistry;
    private Function<JobSetting, SyncOffsetManager> syncOffsetManagerSupplier;
    private Function<JobSetting, SplitManager> splitManagerSupplier;
    private Function<JobSetting, LockManager> lockManagerSupplier;

    @Override
    public JobSetting jobSetting() {
        return this.setting;
    }

    @Override
    public JobInfo jobInfo() {
        return this.setting.getJobInfo();
    }

    @Override
    public JobLogLevel logLevel() {
        return this.setting.getLogLevel();
    }

    @Override
    public String dispatcher() {
        return this.setting.getDispatcher();
    }

    @Override
    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public SyncOffsetManager syncOffsetManager() {
        return this.syncOffsetManagerSupplier.apply(this.getSetting());
    }

    @Override
    public SplitManager splitManager() {
        return this.splitManagerSupplier.apply(this.getSetting());
    }

    @Override
    public LockManager lockManager() {
        return this.lockManagerSupplier.apply(this.getSetting());
    }

    @Override
    public void log(Logger log, Level level, String message, Object ... params) {
        String appendMessage = "group: {}, job: {}, subJob: {}, account: {}, subAccount: {}, " + message;
        LogUtil.log((Logger)log, (Level)level, (String)appendMessage, (Object[])this.appendParams(params));
    }

    private Object[] appendParams(Object ... params) {
        JobInfo jobInfo = this.jobInfo();
        Object[] jobParams = new Object[]{jobInfo.getGroup(), jobInfo.getJob(), jobInfo.getSubJob().orElse("null"), jobInfo.getAccount().orElse("null"), jobInfo.getSubAccount().orElse("null")};
        return ArrayUtils.addAll((Object[])jobParams, (Object[])params);
    }

    @Generated
    public static DefaultJobContextBuilder builder() {
        return new DefaultJobContextBuilder();
    }

    @Generated
    public JobSetting getSetting() {
        return this.setting;
    }

    @Generated
    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    @Generated
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    @Generated
    public Function<JobSetting, SyncOffsetManager> getSyncOffsetManagerSupplier() {
        return this.syncOffsetManagerSupplier;
    }

    @Generated
    public Function<JobSetting, SplitManager> getSplitManagerSupplier() {
        return this.splitManagerSupplier;
    }

    @Generated
    public Function<JobSetting, LockManager> getLockManagerSupplier() {
        return this.lockManagerSupplier;
    }

    @Generated
    public void setSetting(JobSetting setting) {
        this.setting = setting;
    }

    @Generated
    public void setActorSystem(ActorSystem actorSystem) {
        this.actorSystem = actorSystem;
    }

    @Generated
    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Generated
    public void setSyncOffsetManagerSupplier(Function<JobSetting, SyncOffsetManager> syncOffsetManagerSupplier) {
        this.syncOffsetManagerSupplier = syncOffsetManagerSupplier;
    }

    @Generated
    public void setSplitManagerSupplier(Function<JobSetting, SplitManager> splitManagerSupplier) {
        this.splitManagerSupplier = splitManagerSupplier;
    }

    @Generated
    public void setLockManagerSupplier(Function<JobSetting, LockManager> lockManagerSupplier) {
        this.lockManagerSupplier = lockManagerSupplier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultJobContext)) {
            return false;
        }
        DefaultJobContext other = (DefaultJobContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JobSetting this$setting = this.getSetting();
        JobSetting other$setting = other.getSetting();
        if (this$setting == null ? other$setting != null : !((Object)this$setting).equals(other$setting)) {
            return false;
        }
        ActorSystem this$actorSystem = this.getActorSystem();
        ActorSystem other$actorSystem = other.getActorSystem();
        if (this$actorSystem == null ? other$actorSystem != null : !this$actorSystem.equals(other$actorSystem)) {
            return false;
        }
        MeterRegistry this$meterRegistry = this.getMeterRegistry();
        MeterRegistry other$meterRegistry = other.getMeterRegistry();
        if (this$meterRegistry == null ? other$meterRegistry != null : !this$meterRegistry.equals(other$meterRegistry)) {
            return false;
        }
        Function<JobSetting, SyncOffsetManager> this$syncOffsetManagerSupplier = this.getSyncOffsetManagerSupplier();
        Function<JobSetting, SyncOffsetManager> other$syncOffsetManagerSupplier = other.getSyncOffsetManagerSupplier();
        if (this$syncOffsetManagerSupplier == null ? other$syncOffsetManagerSupplier != null : !this$syncOffsetManagerSupplier.equals(other$syncOffsetManagerSupplier)) {
            return false;
        }
        Function<JobSetting, SplitManager> this$splitManagerSupplier = this.getSplitManagerSupplier();
        Function<JobSetting, SplitManager> other$splitManagerSupplier = other.getSplitManagerSupplier();
        if (this$splitManagerSupplier == null ? other$splitManagerSupplier != null : !this$splitManagerSupplier.equals(other$splitManagerSupplier)) {
            return false;
        }
        Function<JobSetting, LockManager> this$lockManagerSupplier = this.getLockManagerSupplier();
        Function<JobSetting, LockManager> other$lockManagerSupplier = other.getLockManagerSupplier();
        return !(this$lockManagerSupplier == null ? other$lockManagerSupplier != null : !this$lockManagerSupplier.equals(other$lockManagerSupplier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultJobContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JobSetting $setting = this.getSetting();
        result = result * 59 + ($setting == null ? 43 : ((Object)$setting).hashCode());
        ActorSystem $actorSystem = this.getActorSystem();
        result = result * 59 + ($actorSystem == null ? 43 : $actorSystem.hashCode());
        MeterRegistry $meterRegistry = this.getMeterRegistry();
        result = result * 59 + ($meterRegistry == null ? 43 : $meterRegistry.hashCode());
        Function<JobSetting, SyncOffsetManager> $syncOffsetManagerSupplier = this.getSyncOffsetManagerSupplier();
        result = result * 59 + ($syncOffsetManagerSupplier == null ? 43 : $syncOffsetManagerSupplier.hashCode());
        Function<JobSetting, SplitManager> $splitManagerSupplier = this.getSplitManagerSupplier();
        result = result * 59 + ($splitManagerSupplier == null ? 43 : $splitManagerSupplier.hashCode());
        Function<JobSetting, LockManager> $lockManagerSupplier = this.getLockManagerSupplier();
        result = result * 59 + ($lockManagerSupplier == null ? 43 : $lockManagerSupplier.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultJobContext(setting=" + String.valueOf(this.getSetting()) + ", actorSystem=" + String.valueOf(this.getActorSystem()) + ", meterRegistry=" + String.valueOf(this.getMeterRegistry()) + ", syncOffsetManagerSupplier=" + String.valueOf(this.getSyncOffsetManagerSupplier()) + ", splitManagerSupplier=" + String.valueOf(this.getSplitManagerSupplier()) + ", lockManagerSupplier=" + String.valueOf(this.getLockManagerSupplier()) + ")";
    }

    @Generated
    public DefaultJobContext() {
    }

    @Generated
    public DefaultJobContext(JobSetting setting, ActorSystem actorSystem, MeterRegistry meterRegistry, Function<JobSetting, SyncOffsetManager> syncOffsetManagerSupplier, Function<JobSetting, SplitManager> splitManagerSupplier, Function<JobSetting, LockManager> lockManagerSupplier) {
        this.setting = setting;
        this.actorSystem = actorSystem;
        this.meterRegistry = meterRegistry;
        this.syncOffsetManagerSupplier = syncOffsetManagerSupplier;
        this.splitManagerSupplier = splitManagerSupplier;
        this.lockManagerSupplier = lockManagerSupplier;
    }

    @Generated
    public static class DefaultJobContextBuilder {
        @Generated
        private JobSetting setting;
        @Generated
        private ActorSystem actorSystem;
        @Generated
        private MeterRegistry meterRegistry;
        @Generated
        private Function<JobSetting, SyncOffsetManager> syncOffsetManagerSupplier;
        @Generated
        private Function<JobSetting, SplitManager> splitManagerSupplier;
        @Generated
        private Function<JobSetting, LockManager> lockManagerSupplier;

        @Generated
        DefaultJobContextBuilder() {
        }

        @Generated
        public DefaultJobContextBuilder setting(JobSetting setting) {
            this.setting = setting;
            return this;
        }

        @Generated
        public DefaultJobContextBuilder actorSystem(ActorSystem actorSystem) {
            this.actorSystem = actorSystem;
            return this;
        }

        @Generated
        public DefaultJobContextBuilder meterRegistry(MeterRegistry meterRegistry) {
            this.meterRegistry = meterRegistry;
            return this;
        }

        @Generated
        public DefaultJobContextBuilder syncOffsetManagerSupplier(Function<JobSetting, SyncOffsetManager> syncOffsetManagerSupplier) {
            this.syncOffsetManagerSupplier = syncOffsetManagerSupplier;
            return this;
        }

        @Generated
        public DefaultJobContextBuilder splitManagerSupplier(Function<JobSetting, SplitManager> splitManagerSupplier) {
            this.splitManagerSupplier = splitManagerSupplier;
            return this;
        }

        @Generated
        public DefaultJobContextBuilder lockManagerSupplier(Function<JobSetting, LockManager> lockManagerSupplier) {
            this.lockManagerSupplier = lockManagerSupplier;
            return this;
        }

        @Generated
        public DefaultJobContext build() {
            return new DefaultJobContext(this.setting, this.actorSystem, this.meterRegistry, this.syncOffsetManagerSupplier, this.splitManagerSupplier, this.lockManagerSupplier);
        }

        @Generated
        public String toString() {
            return "DefaultJobContext.DefaultJobContextBuilder(setting=" + String.valueOf(this.setting) + ", actorSystem=" + String.valueOf(this.actorSystem) + ", meterRegistry=" + String.valueOf(this.meterRegistry) + ", syncOffsetManagerSupplier=" + String.valueOf(this.syncOffsetManagerSupplier) + ", splitManagerSupplier=" + String.valueOf(this.splitManagerSupplier) + ", lockManagerSupplier=" + String.valueOf(this.lockManagerSupplier) + ")";
        }
    }
}

