/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model.processor;

import cn.sliew.carp.module.http.sync.framework.model.job.JobInfo;
import cn.sliew.carp.module.http.sync.framework.model.job.JobLogLevel;
import cn.sliew.carp.module.http.sync.framework.model.processor.JobContext;
import cn.sliew.carp.module.http.sync.framework.model.processor.JobProcessor;
import cn.sliew.carp.module.http.sync.framework.model.processor.ProcessResult;
import cn.sliew.carp.module.http.sync.framework.model.processor.Result;
import cn.sliew.carp.module.http.sync.framework.model.processor.RootTask;
import cn.sliew.carp.module.http.sync.framework.model.processor.SubTask;
import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.JacksonUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class DefaultJobProcessor<Context extends JobContext, Root extends RootTask, Sub extends SubTask>
implements JobProcessor<Context, Root, Sub> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultJobProcessor.class);
    private final Context context;

    public DefaultJobProcessor(Context context) {
        this.context = context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public List<Sub> map(Root rootTask) {
        return rootTask.split(this.getContext());
    }

    @Override
    public CompletableFuture<Result> process(Sub subTask) {
        return subTask.execute(this.context);
    }

    @Override
    public Result reduce(Result result) {
        JobInfo jobInfo = this.context.jobInfo();
        SubTask subTask = result.getSubTask();
        if (!result.isSuccess()) {
            if (this.context.logLevel() == JobLogLevel.SIMPLE || this.context.logLevel() == JobLogLevel.COMPLEX || this.context.logLevel() == JobLogLevel.FULL) {
                this.context.log(log, Level.ERROR, "{}-{}, \u5b50\u4efb\u52a1\u5904\u7406\u5931\u8d25, \u5b50\u4efb\u52a1\u8be6\u60c5: {}, \u5931\u8d25\u4fe1\u606f: {}", subTask.getRootTask().getIdentifier(), subTask.getIdentifier(), JacksonUtil.toJsonString((Object)subTask), result.getMessage(), result.getThrowable());
            }
            if (result.getThrowable() != null) {
                Rethrower.throwAs((Throwable)result.getThrowable());
            }
            throw new RuntimeException(result.getMessage());
        }
        if (this.context.logLevel() == JobLogLevel.COMPLEX || this.context.logLevel() == JobLogLevel.FULL) {
            this.context.log(log, Level.DEBUG, "{}-{}, \u5b50\u4efb\u52a1\u5904\u7406\u6210\u529f, \u5b50\u4efb\u52a1\u8be6\u60c5: {}", subTask.getRootTask().getIdentifier(), subTask.getIdentifier(), JacksonUtil.toJsonString((Object)subTask));
        }
        this.context.syncOffsetManager().updateSyncOffset(this.context, subTask.getEndSyncOffset());
        return ProcessResult.success(result.getSubTask());
    }
}

