/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.plugin.plugin;

import cn.sliew.carp.framework.common.nio.FileUtil;
import cn.sliew.carp.module.plugin.service.CarpPluginReleaseService;
import cn.sliew.carp.module.plugin.service.CarpPluginStatusService;
import cn.sliew.carp.module.plugin.service.dto.CarpPluginReleaseDTO;
import cn.sliew.carp.module.plugin.service.dto.CarpPluginStatusDTO;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.pf4j.PluginRepository;
import org.pf4j.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CustomPluginRepository
implements PluginRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomPluginRepository.class);
    private CarpPluginReleaseService carpPluginReleaseService;
    private CarpPluginStatusService carpPluginStatusService;
    protected FileFilter filter;

    public CustomPluginRepository(CarpPluginReleaseService carpPluginReleaseService, CarpPluginStatusService carpPluginStatusService) {
        this(carpPluginReleaseService, carpPluginStatusService, null);
    }

    public CustomPluginRepository(CarpPluginReleaseService carpPluginReleaseService, CarpPluginStatusService carpPluginStatusService, FileFilter filter) {
        this.carpPluginReleaseService = carpPluginReleaseService;
        this.carpPluginStatusService = carpPluginStatusService;
        this.filter = filter;
    }

    public List<Path> getPluginPaths() {
        List<CarpPluginStatusDTO> startedPlugins = this.carpPluginStatusService.list(PluginState.STARTED);
        if (CollectionUtils.isEmpty(startedPlugins)) {
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (CarpPluginStatusDTO statusDTO : startedPlugins) {
            CarpPluginReleaseDTO releaseDTO = this.carpPluginReleaseService.getByUuid(statusDTO.getPluginUuid());
            try {
                Path path = this.carpPluginReleaseService.internalDownloadPlugin(releaseDTO);
                if (!Objects.isNull(this.filter) && !this.filter.accept(path.toFile())) continue;
                paths.add(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return paths;
    }

    public boolean deletePluginPath(Path path) {
        try {
            FileUtil.deleteFile((Path)path);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

