/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.plugin.plugin.update;

import cn.sliew.carp.framework.common.model.PageParam;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.module.plugin.plugin.update.PluginRepositoryInfo;
import cn.sliew.carp.module.plugin.plugin.update.RemotePluginInfo;
import cn.sliew.carp.module.plugin.plugin.update.RemotePluginRepository;
import cn.sliew.carp.module.plugin.repository.entity.CarpPluginInfo;
import cn.sliew.carp.module.plugin.repository.mapper.CarpPluginInfoMapper;
import cn.sliew.carp.module.plugin.service.convert.CarpPluginRepositoryInfoConvert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class InternalRemotePluginRepository
extends ServiceImpl<CarpPluginInfoMapper, CarpPluginInfo>
implements RemotePluginRepository,
InitializingBean {
    private PluginRepositoryInfo repositoryInfo;

    public void afterPropertiesSet() throws Exception {
        this.repositoryInfo = new PluginRepositoryInfo();
        this.repositoryInfo.setId("id");
        this.repositoryInfo.setUrl("https://repo1.maven.org/maven2/cn/sliew/");
        this.repositoryInfo.setProvider("carp");
    }

    @Override
    public PluginRepositoryInfo getInfo() {
        return this.repositoryInfo;
    }

    @Override
    public PageResult<RemotePluginInfo> page(PageParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page carpPluginInfoPage = (Page)this.page((IPage)page, (Wrapper)Wrappers.emptyWrapper());
        PageResult pageResult = new PageResult(Long.valueOf(carpPluginInfoPage.getCurrent()), Long.valueOf(carpPluginInfoPage.getSize()), Long.valueOf(carpPluginInfoPage.getTotal()));
        List remotePluginInfos = carpPluginInfoPage.getRecords().stream().map(record -> {
            RemotePluginInfo dto = CarpPluginRepositoryInfoConvert.INSTANCE.toDto((CarpPluginInfo)((Object)record));
            dto.setProvider(this.repositoryInfo.getUrl());
            return dto;
        }).collect(Collectors.toList());
        pageResult.setRecords(remotePluginInfos);
        return pageResult;
    }

    @Override
    public List<RemotePluginInfo> getAll() {
        List entities = this.list((Wrapper)Wrappers.emptyWrapper());
        return entities.stream().map(record -> {
            RemotePluginInfo dto = CarpPluginRepositoryInfoConvert.INSTANCE.toDto((CarpPluginInfo)((Object)record));
            dto.setProvider(this.repositoryInfo.getUrl());
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public RemotePluginInfo get(String id) {
        CarpPluginInfo entity = (CarpPluginInfo)((Object)this.getOptById((Serializable)((Object)id)).orElseThrow(() -> new IllegalArgumentException("plugin info not exists for id: " + id)));
        RemotePluginInfo dto = CarpPluginRepositoryInfoConvert.INSTANCE.toDto(entity);
        dto.setProvider(this.repositoryInfo.getUrl());
        return dto;
    }
}

