/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.job.task.jst.order;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.sliew.carp.framework.exception.SliewException;
import cn.sliew.carp.framework.mybatis.entity.BaseDO;
import cn.sliew.carp.module.http.sync.framework.model.job.JobLogLevel;
import cn.sliew.carp.module.http.sync.framework.model.processor.DefaultJobContext;
import cn.sliew.carp.module.http.sync.framework.model.processor.FetchResult;
import cn.sliew.carp.module.http.sync.job.remote.JstRemoteService;
import cn.sliew.carp.module.http.sync.job.repository.entity.jst.JstOrder;
import cn.sliew.carp.module.http.sync.job.repository.mapper.jst.JstOrderMapper;
import cn.sliew.carp.module.http.sync.job.task.jst.AbstractJstSubTask;
import cn.sliew.carp.module.http.sync.job.task.jst.order.JstOrderRootTask;
import cn.sliew.carp.module.http.sync.job.task.jst.util.JstResultWrapper;
import cn.sliew.carp.module.http.sync.job.task.jst.util.JstUtil;
import cn.sliew.carp.module.http.sync.remote.jst.request.order.OrdersSingleQuery;
import cn.sliew.carp.module.http.sync.remote.jst.response.JstNewResult;
import cn.sliew.carp.module.http.sync.remote.jst.response.order.JstOrdersResult;
import cn.sliew.carp.module.http.sync.remote.jst.response.order.OrdersSingleDO;
import cn.sliew.milky.common.util.JacksonUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pekko.japi.Pair;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.stream.javadsl.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class JstOrderSubTask
extends AbstractJstSubTask<JstOrderRootTask, OrdersSingleQuery, JstOrdersResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JstOrderSubTask.class);
    private final JstRemoteService remoteService;
    private final JstOrderMapper jstOrderMapper;

    public JstOrderSubTask(Long subTaskId, JstOrderRootTask rootTask, String startSyncOffset, String endSyncOffset, JstRemoteService remoteService, JstOrderMapper jstOrderMapper) {
        super(subTaskId, rootTask, startSyncOffset, endSyncOffset);
        this.remoteService = remoteService;
        this.jstOrderMapper = jstOrderMapper;
    }

    protected Source<FetchResult<OrdersSingleQuery, JstOrdersResult>, ?> fetch(DefaultJobContext context) {
        OrdersSingleQuery first = this.buildFirstRequest(context);
        return Source.unfoldAsync((Object)first, (Function & Serializable)key -> {
            if (key == null) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            JstOrdersResult jstOrdersResult = this.requestRemote(context, (OrdersSingleQuery)key);
            FetchResult fetchResult = new FetchResult(key, (Object)jstOrdersResult);
            if (jstOrdersResult.isHasNext()) {
                OrdersSingleQuery next = (OrdersSingleQuery)BeanUtil.copyProperties((Object)key, OrdersSingleQuery.class, (String[])new String[0]);
                next.setPageIndex(key.getPageIndex() + 1);
                return CompletableFuture.completedFuture(Optional.of(Pair.create((Object)next, (Object)fetchResult)));
            }
            return CompletableFuture.completedFuture(Optional.of(Pair.create(null, (Object)fetchResult)));
        });
    }

    protected OrdersSingleQuery buildFirstRequest(DefaultJobContext context) {
        OrdersSingleQuery query = new OrdersSingleQuery();
        query.setModifiedBegin(this.getStartSyncOffset());
        query.setModifiedEnd(this.getEndSyncOffset());
        query.setPageIndex(1);
        query.setPageSize(50);
        return query;
    }

    protected JstOrdersResult requestRemote(DefaultJobContext context, OrdersSingleQuery request) {
        JstNewResult<JstOrdersResult> jstNewResult = this.remoteService.getOrders(((JstOrderRootTask)this.getRootTask()).getJstAuth(), request);
        if (jstNewResult.isSuccess()) {
            JstOrdersResult jstResult = (JstOrdersResult)jstNewResult.getData();
            JstResultWrapper<Long> jstResultWrapper = JstUtil.convertResult(jstResult, OrdersSingleDO::getOId);
            if (context.logLevel() == JobLogLevel.COMPLEX || context.logLevel() == JobLogLevel.FULL) {
                context.log(log, Level.DEBUG, "\u8bf7\u6c42\u805a\u6c34\u6f6d\u63a5\u53e3\u6210\u529f, request: {}, result: {}", new Object[]{JacksonUtil.toJsonString((Object)request), JacksonUtil.toJsonString(jstResultWrapper)});
            }
            return jstResult;
        }
        if (context.logLevel() == JobLogLevel.COMPLEX || context.logLevel() == JobLogLevel.FULL) {
            context.log(log, Level.ERROR, "\u8bf7\u6c42\u805a\u6c34\u6f6d\u63a5\u53e3\u5931\u8d25, code: {}, msg: {}, query: {}", new Object[]{jstNewResult.getCode(), jstNewResult.getMsg(), JacksonUtil.toJsonString((Object)request)});
        }
        throw new SliewException(Objects.toString(jstNewResult.getCode()), jstNewResult.getMsg());
    }

    protected void persistData(DefaultJobContext context, OrdersSingleQuery request, JstOrdersResult response) {
        if (CollectionUtils.isEmpty((Collection)response.getDatas())) {
            return;
        }
        response.getDatas().forEach(data -> this.upsert(request, (OrdersSingleDO)data));
    }

    private void upsert(OrdersSingleQuery request, OrdersSingleDO data) {
        JstOrder record = this.convert(request, data);
        LambdaQueryWrapper queryWrapper = ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(JstOrder.class).eq(JstOrder::getAppKey, (Object)record.getAppKey())).eq(JstOrder::getCompany, (Object)record.getCompany())).eq(JstOrder::getOId, (Object)record.getOId())).select(new SFunction[]{BaseDO::getId});
        JstOrder jstOrder = (JstOrder)((Object)this.jstOrderMapper.selectOne((Wrapper)queryWrapper));
        if (jstOrder != null) {
            record.setId(jstOrder.getId());
            record.setEditor("sync-task");
            this.jstOrderMapper.updateById((Object)record);
        } else {
            record.setCreator("sync-task");
            record.setEditor("sync-task");
            this.jstOrderMapper.insert((Object)record);
        }
    }

    private JstOrder convert(OrdersSingleQuery request, OrdersSingleDO data) {
        JstOrder record = (JstOrder)((Object)BeanUtil.copyProperties((Object)data, JstOrder.class, (String[])new String[0]));
        if (!CollectionUtils.isEmpty((Collection)data.getItems())) {
            record.setItems(JacksonUtil.toJsonString((Object)data.getItems()));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)data.getPays())) {
            record.setPays(JacksonUtil.toJsonString((Object)data.getPays()));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)data.getRawSoIds())) {
            record.setRawSoIds(JacksonUtil.toJsonString((Object)data.getRawSoIds()));
        }
        record.setSyncStartTime(DateUtil.parse((CharSequence)request.getModifiedBegin(), (String)"yyyy-MM-dd HH:mm:ss").toJdkDate());
        record.setSyncEndTime(DateUtil.parse((CharSequence)request.getModifiedEnd(), (String)"yyyy-MM-dd HH:mm:ss").toJdkDate());
        record.setSyncPageIndex(request.getPageIndex());
        record.setSyncPageSize(request.getPageSize());
        return record;
    }
}

