/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.core.controller;

import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.log.annotation.WebLog;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import cn.sliew.carp.module.security.core.service.SecAuthorizationService;
import cn.sliew.carp.module.security.core.service.dto.SecResourceWebWithAuthorizeDTO;
import cn.sliew.carp.module.security.core.service.dto.SecRoleDTO;
import cn.sliew.carp.module.security.core.service.dto.SecUserDTO;
import cn.sliew.carp.module.security.core.service.param.authorize.SecResourceWebBatchAuthorizeForRoleParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecResourceWebListByRoleParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleBatchAuthorizeForResourceWebParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleBatchAuthorizeForUserParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleListByResourceWebParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleListByUserParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecUserBatchAuthorizeForRoleParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecUserListByRoleParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@WebLog
@RestController
@ApiResponseWrapper
@RequestMapping(value={"/api/carp/security/authorization"})
@Tag(name="\u6743\u9650\u6a21\u5757-\u6388\u6743\u7ba1\u7406")
public class SecAuthorizationController {
    @Autowired
    private SecAuthorizationService secAuthorizationService;

    @GetMapping(value={"resource-web/authorized-roles"})
    @Operation(summary="\u67e5\u8be2 \u8d44\u6e90-web \u7ed1\u5b9a\u89d2\u8272\u5217\u8868", description="\u67e5\u8be2 \u8d44\u6e90-web \u7ed1\u5b9a\u89d2\u8272\u5217\u8868")
    public PageResult<SecRoleDTO> listAuthorizedRolesByResourceWebId(@Valid SecRoleListByResourceWebParam param) {
        return this.secAuthorizationService.listAuthorizedRolesByResourceWebId(param);
    }

    @GetMapping(value={"resource-web/unauthorized-roles"})
    @Operation(summary="\u67e5\u8be2 \u8d44\u6e90-web \u672a\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", description="\u67e5\u8be2 \u8d44\u6e90-web \u672a\u7ed1\u5b9a\u89d2\u8272\u5217\u8868")
    public PageResult<SecRoleDTO> listUnauthorizedRolesByResourceWebId(@Valid SecRoleListByResourceWebParam param) {
        return this.secAuthorizationService.listUnauthorizedRolesByResourceWebId(param);
    }

    @PutMapping(value={"resource-web/roles"})
    @Operation(summary="\u6279\u91cf\u4e3a \u8d44\u6e90-web \u7ed1\u5b9a\u89d2\u8272", description="\u6279\u91cf\u4e3a \u8d44\u6e90-web \u7ed1\u5b9a\u89d2\u8272")
    public void authorize(@Valid @RequestBody SecRoleBatchAuthorizeForResourceWebParam param) {
        this.secAuthorizationService.authorize(param);
    }

    @DeleteMapping(value={"resource-web/roles"})
    @Operation(summary="\u6279\u91cf\u4e3a \u8d44\u6e90-web \u89e3\u9664\u89d2\u8272\u7ed1\u5b9a", description="\u6279\u91cf\u4e3a \u8d44\u6e90-web \u89e3\u9664\u89d2\u8272\u7ed1\u5b9a")
    public void unauthorize(@Valid @RequestBody SecRoleBatchAuthorizeForResourceWebParam param) {
        this.secAuthorizationService.unauthorize(param);
    }

    @GetMapping(value={"role/resource-webs"})
    @Operation(summary="\u67e5\u8be2\u6240\u6709 \u8d44\u6e90-web \u548c\u6307\u5b9a\u89d2\u8272\u7ed1\u5b9a\u72b6\u6001", description="\u67e5\u8be2\u6240\u6709 \u8d44\u6e90-web \u548c\u6307\u5b9a\u89d2\u8272\u7ed1\u5b9a\u72b6\u6001")
    public List<SecResourceWebWithAuthorizeDTO> listResourceWebsByRole(@Valid SecResourceWebListByRoleParam param) {
        List<SecResourceWebWithAuthorizeDTO> result = this.secAuthorizationService.listResourceWebsByRoleId(param);
        return result;
    }

    @PutMapping(value={"role/resource-webs"})
    @Operation(summary="\u6279\u91cf\u4e3a\u89d2\u8272\u7ed1\u5b9a \u8d44\u6e90-web", description="\u6279\u91cf\u4e3a\u89d2\u8272\u7ed1\u5b9a \u8d44\u6e90-web")
    public void authorize(@Valid @RequestBody SecResourceWebBatchAuthorizeForRoleParam param) {
        this.secAuthorizationService.authorize(param);
    }

    @DeleteMapping(value={"role/resource-webs"})
    @Operation(summary="\u6279\u91cf\u4e3a\u89d2\u8272\u89e3\u9664 \u8d44\u6e90-web \u7ed1\u5b9a", description="\u6279\u91cf\u4e3a\u89d2\u8272\u89e3\u9664 \u8d44\u6e90-web \u7ed1\u5b9a")
    public void unauthorize(@Valid @RequestBody SecResourceWebBatchAuthorizeForRoleParam param) {
        this.secAuthorizationService.unauthorize(param);
    }

    @GetMapping(value={"role/authorized-users"})
    @Operation(summary="\u67e5\u8be2\u89d2\u8272\u7ed1\u5b9a\u7528\u6237\u5217\u8868", description="\u67e5\u8be2\u89d2\u8272\u7ed1\u5b9a\u7528\u6237\u5217\u8868")
    public PageResult<SecUserDTO> listAuthorizedUsersByRoleId(@Valid SecUserListByRoleParam param) {
        return this.secAuthorizationService.listAuthorizedUsersByRoleId(param);
    }

    @GetMapping(value={"role/unauthorized-users"})
    @Operation(summary="\u67e5\u8be2\u89d2\u8272\u672a\u7ed1\u5b9a\u7528\u6237\u5217\u8868", description="\u67e5\u8be2\u89d2\u8272\u672a\u7ed1\u5b9a\u7528\u6237\u5217\u8868")
    public PageResult<SecUserDTO> listUnauthorizedUsersByRoleId(@Valid SecUserListByRoleParam param) {
        return this.secAuthorizationService.listUnauthorizedUsersByRoleId(param);
    }

    @PutMapping(value={"role/users"})
    @Operation(summary="\u6279\u91cf\u4e3a\u89d2\u8272\u7ed1\u5b9a\u7528\u6237", description="\u6279\u91cf\u4e3a\u89d2\u8272\u7ed1\u5b9a\u7528\u6237")
    public void authorize(@Valid @RequestBody SecUserBatchAuthorizeForRoleParam param) {
        this.secAuthorizationService.authorize(param);
    }

    @DeleteMapping(value={"role/users"})
    @Operation(summary="\u6279\u91cf\u4e3a\u89d2\u8272\u89e3\u9664\u7528\u6237\u7ed1\u5b9a", description="\u6279\u91cf\u4e3a\u89d2\u8272\u89e3\u9664\u7528\u6237\u7ed1\u5b9a")
    public void unauthorize(@Valid @RequestBody SecUserBatchAuthorizeForRoleParam param) {
        this.secAuthorizationService.unauthorize(param);
    }

    @GetMapping(value={"user/authorized-roles"})
    @Operation(summary="\u67e5\u8be2\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", description="\u67e5\u8be2\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868")
    public PageResult<SecRoleDTO> listAuthorizedRolesByUserId(@Valid SecRoleListByUserParam param) {
        return this.secAuthorizationService.listAuthorizedRolesByUserId(param);
    }

    @GetMapping(value={"user/unauthorized-roles"})
    @Operation(summary="\u67e5\u8be2\u7528\u6237\u672a\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", description="\u67e5\u8be2\u7528\u6237\u672a\u7ed1\u5b9a\u89d2\u8272\u5217\u8868")
    public PageResult<SecRoleDTO> listUnauthorizedRolesByUserId(@Valid SecRoleListByUserParam param) {
        return this.secAuthorizationService.listUnauthorizedRolesByUserId(param);
    }

    @PutMapping(value={"user/roles"})
    @Operation(summary="\u6279\u91cf\u4e3a\u7528\u6237\u7ed1\u5b9a\u89d2\u8272", description="\u6279\u91cf\u4e3a\u7528\u6237\u7ed1\u5b9a\u89d2\u8272")
    public void authorize(@Valid @RequestBody SecRoleBatchAuthorizeForUserParam param) {
        this.secAuthorizationService.authorize(param);
    }

    @DeleteMapping(value={"user/roles"})
    @Operation(summary="\u6279\u91cf\u4e3a\u7528\u6237\u89e3\u9664\u89d2\u8272\u7ed1\u5b9a", description="\u6279\u91cf\u4e3a\u7528\u6237\u89e3\u9664\u89d2\u8272\u7ed1\u5b9a")
    public void unauthorize(@Valid @RequestBody SecRoleBatchAuthorizeForUserParam param) {
        this.secAuthorizationService.unauthorize(param);
    }
}

