/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.core.service.impl;

import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.module.security.core.repository.entity.SecResourceWeb;
import cn.sliew.carp.module.security.core.repository.entity.SecResourceWebRole;
import cn.sliew.carp.module.security.core.repository.entity.SecResourceWebVO;
import cn.sliew.carp.module.security.core.repository.entity.SecRole;
import cn.sliew.carp.module.security.core.repository.mapper.SecResourceWebRoleMapper;
import cn.sliew.carp.module.security.core.service.SecResourceWebRoleService;
import cn.sliew.carp.module.security.core.service.convert.SecResourceWebConvert;
import cn.sliew.carp.module.security.core.service.convert.SecResourceWebWithAuthorizeConvert;
import cn.sliew.carp.module.security.core.service.convert.SecRoleConvert;
import cn.sliew.carp.module.security.core.service.dto.SecResourceWebDTO;
import cn.sliew.carp.module.security.core.service.dto.SecResourceWebWithAuthorizeDTO;
import cn.sliew.carp.module.security.core.service.dto.SecRoleDTO;
import cn.sliew.carp.module.security.core.service.param.authorize.SecResourceWebBatchAuthorizeForRoleParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecResourceWebListByRoleParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleBatchAuthorizeForResourceWebParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleListByResourceWebParam;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SecResourceWebRoleServiceImpl
extends ServiceImpl<SecResourceWebRoleMapper, SecResourceWebRole>
implements SecResourceWebRoleService {
    @Override
    public PageResult<SecRoleDTO> listAuthorizedRolesByResourceWebId(SecRoleListByResourceWebParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page<SecRole> secRolePage = ((SecResourceWebRoleMapper)this.baseMapper).selectRelatedRolesByWebResource(page, param.getResourceWebId(), param.getStatus(), param.getName());
        PageResult result = new PageResult(Long.valueOf(secRolePage.getCurrent()), Long.valueOf(secRolePage.getSize()), Long.valueOf(secRolePage.getTotal()));
        List secRoleDTOS = SecRoleConvert.INSTANCE.toDto(secRolePage.getRecords());
        result.setRecords(secRoleDTOS);
        return result;
    }

    @Override
    public PageResult<SecRoleDTO> listUnauthorizedRolesByResourceWebId(SecRoleListByResourceWebParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page<SecRole> secRolePage = ((SecResourceWebRoleMapper)this.baseMapper).selectUnrelatedRolesByWebResource(page, param.getResourceWebId(), param.getStatus(), param.getName());
        PageResult result = new PageResult(Long.valueOf(secRolePage.getCurrent()), Long.valueOf(secRolePage.getSize()), Long.valueOf(secRolePage.getTotal()));
        List secRoleDTOS = SecRoleConvert.INSTANCE.toDto(secRolePage.getRecords());
        result.setRecords(secRoleDTOS);
        return result;
    }

    @Override
    public void authorize(SecRoleBatchAuthorizeForResourceWebParam param) {
        for (Long roleId : param.getRoleIds()) {
            SecResourceWebRole record = new SecResourceWebRole();
            record.setResourceWebId(param.getResourceWebId());
            record.setRoleId(roleId);
            ((SecResourceWebRoleMapper)this.baseMapper).insert((Object)record);
        }
    }

    @Override
    public void unauthorize(SecRoleBatchAuthorizeForResourceWebParam param) {
        for (Long roleId : param.getRoleIds()) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecResourceWebRole.class).eq(SecResourceWebRole::getResourceWebId, (Object)param.getResourceWebId())).eq(SecResourceWebRole::getRoleId, (Object)roleId);
            ((SecResourceWebRoleMapper)this.baseMapper).delete((Wrapper)queryWrapper);
        }
    }

    @Override
    public void deleteByResourceWebId(Long resourceWebId) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate(SecResourceWebRole.class).eq(SecResourceWebRole::getResourceWebId, (Object)resourceWebId);
        ((SecResourceWebRoleMapper)this.baseMapper).delete((Wrapper)updateWrapper);
    }

    @Override
    public List<SecResourceWebWithAuthorizeDTO> listResourceWebsByRoleId(SecResourceWebListByRoleParam param) {
        List<SecResourceWebVO> secResourceWebVOS = ((SecResourceWebRoleMapper)this.baseMapper).selectAllResourceWebWithAuthorizeStatus(param.getRoleId(), 0L);
        List result = SecResourceWebWithAuthorizeConvert.INSTANCE.toDto(secResourceWebVOS);
        result.forEach(dto -> this.recurse(param.getRoleId(), (SecResourceWebWithAuthorizeDTO)((Object)dto)));
        return result;
    }

    @Override
    public List<SecResourceWebDTO> listAuthorizedResourceWebsByRoleId(SecResourceWebListByRoleParam param) {
        List<SecResourceWeb> secResourceWebS = ((SecResourceWebRoleMapper)this.baseMapper).selectRelatedWebResourceByRole(param.getRoleId());
        return SecResourceWebConvert.INSTANCE.toDto(secResourceWebS);
    }

    private void recurse(Long roleId, SecResourceWebWithAuthorizeDTO resourceWebDTO) {
        List<SecResourceWebWithAuthorizeDTO> children = this.listResourceWebsByRoleIdAndPid(roleId, resourceWebDTO.getId());
        if (!CollectionUtils.isEmpty(children)) {
            resourceWebDTO.setChildren(children);
            children.forEach(child -> this.recurse(roleId, (SecResourceWebWithAuthorizeDTO)((Object)child)));
        }
    }

    private List<SecResourceWebWithAuthorizeDTO> listResourceWebsByRoleIdAndPid(Long roleId, Long pid) {
        List<SecResourceWebVO> secResourceWebVOS = ((SecResourceWebRoleMapper)this.baseMapper).selectAllResourceWebWithAuthorizeStatus(roleId, pid);
        return SecResourceWebWithAuthorizeConvert.INSTANCE.toDto(secResourceWebVOS);
    }

    @Override
    public void authorize(SecResourceWebBatchAuthorizeForRoleParam param) {
        for (Long resourceWebId : param.getResourceWebIds()) {
            SecResourceWebRole record = new SecResourceWebRole();
            record.setResourceWebId(resourceWebId);
            record.setRoleId(param.getRoleId());
            ((SecResourceWebRoleMapper)this.baseMapper).insert((Object)record);
        }
    }

    @Override
    public void unauthorize(SecResourceWebBatchAuthorizeForRoleParam param) {
        for (Long resourceWebId : param.getResourceWebIds()) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecResourceWebRole.class).eq(SecResourceWebRole::getResourceWebId, (Object)resourceWebId)).eq(SecResourceWebRole::getRoleId, (Object)param.getRoleId());
            ((SecResourceWebRoleMapper)this.baseMapper).delete((Wrapper)queryWrapper);
        }
    }

    @Override
    public void deleteByRoleId(Long roleId) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate(SecResourceWebRole.class).eq(SecResourceWebRole::getRoleId, (Object)roleId);
        ((SecResourceWebRoleMapper)this.baseMapper).delete((Wrapper)updateWrapper);
    }
}

