/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.core.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.mybatis.entity.BaseDO;
import cn.sliew.carp.module.security.core.repository.entity.SecResourceWeb;
import cn.sliew.carp.module.security.core.repository.mapper.SecResourceWebMapper;
import cn.sliew.carp.module.security.core.service.SecResourceWebRoleService;
import cn.sliew.carp.module.security.core.service.SecResourceWebService;
import cn.sliew.carp.module.security.core.service.convert.SecResourceWebConvert;
import cn.sliew.carp.module.security.core.service.dto.SecResourceWebDTO;
import cn.sliew.carp.module.security.core.service.param.SecResourceWebAddParam;
import cn.sliew.carp.module.security.core.service.param.SecResourceWebListParam;
import cn.sliew.carp.module.security.core.service.param.SecResourceWebUpdateParam;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SecResourceWebServiceImpl
extends ServiceImpl<SecResourceWebMapper, SecResourceWeb>
implements SecResourceWebService {
    @Autowired
    private SecResourceWebRoleService secResourceWebRoleService;

    @Override
    public PageResult<SecResourceWebDTO> page(SecResourceWebListParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecResourceWeb.class).eq(SecResourceWeb::getPid, (Object)(param.getPid() != null ? param.getPid() : 0L))).like(StringUtils.hasText((String)param.getLabel()), SecResourceWeb::getLabel, (Object)param.getLabel())).orderByAsc(SecResourceWeb::getOrder, new SFunction[]{BaseDO::getId});
        Page secResourceWebPage = (Page)this.page((IPage)page, (Wrapper)queryChainWrapper);
        PageResult pageResult = new PageResult(Long.valueOf(secResourceWebPage.getCurrent()), Long.valueOf(secResourceWebPage.getSize()), Long.valueOf(secResourceWebPage.getTotal()));
        pageResult.setRecords(SecResourceWebConvert.INSTANCE.toDto(secResourceWebPage.getRecords()));
        pageResult.getRecords().forEach(dto -> this.recurse((SecResourceWebDTO)((Object)dto), param.getLabel()));
        return pageResult;
    }

    private void recurse(SecResourceWebDTO resourceWebDTO, String label) {
        List<SecResourceWebDTO> children = this.listByPid(resourceWebDTO.getId(), label);
        if (!CollectionUtils.isEmpty(children)) {
            resourceWebDTO.setChildren(children);
            resourceWebDTO.setIsLeaf(false);
            children.forEach(child -> this.recurse((SecResourceWebDTO)((Object)child), label));
        } else {
            resourceWebDTO.setIsLeaf(true);
        }
    }

    @Override
    public List<SecResourceWebDTO> listAll(SecResourceWebListParam param) {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecResourceWeb.class).eq(param.getPid() != null, SecResourceWeb::getPid, (Object)param.getPid())).like(StringUtils.hasText((String)param.getLabel()), SecResourceWeb::getLabel, (Object)param.getLabel())).orderByAsc(SecResourceWeb::getOrder, new SFunction[]{BaseDO::getId});
        List entities = this.list((Wrapper)queryChainWrapper);
        return SecResourceWebConvert.INSTANCE.toDto(entities);
    }

    @Override
    public List<SecResourceWebDTO> listByPid(Long pid, String label) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecResourceWeb.class).eq(SecResourceWeb::getPid, (Object)pid)).like(StringUtils.hasText((String)label), SecResourceWeb::getLabel, (Object)label);
        List list = this.list((Wrapper)queryWrapper);
        return SecResourceWebConvert.INSTANCE.toDto(list);
    }

    @Override
    public SecResourceWebDTO get(Long id) {
        SecResourceWeb entity = (SecResourceWeb)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("resource web not exists for id: " + id)));
        return (SecResourceWebDTO)((Object)SecResourceWebConvert.INSTANCE.toDto((Object)entity));
    }

    @Override
    public boolean add(SecResourceWebAddParam param) {
        SecResourceWeb entity = (SecResourceWeb)((Object)BeanUtil.copyProperties((Object)param, SecResourceWeb.class, (String[])new String[0]));
        return this.save((Object)entity);
    }

    @Override
    public boolean update(SecResourceWebUpdateParam param) {
        SecResourceWeb entity = (SecResourceWeb)((Object)BeanUtil.copyProperties((Object)param, SecResourceWeb.class, (String[])new String[0]));
        return this.saveOrUpdate((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean delete(Long id) {
        SecResourceWebListParam param = new SecResourceWebListParam();
        param.setPid(id);
        List<SecResourceWebDTO> children = this.listAll(param);
        if (!CollectionUtils.isEmpty(children)) {
            children.forEach(child -> this.delete(child.getId()));
        }
        this.secResourceWebRoleService.deleteByResourceWebId(id);
        return this.removeById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean deleteBatch(Collection<Long> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            ids.forEach(this::delete);
        }
        return true;
    }
}

