/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.core.service.impl;

import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.module.security.core.repository.entity.SecRole;
import cn.sliew.carp.module.security.core.repository.entity.SecUser;
import cn.sliew.carp.module.security.core.repository.entity.SecUserRole;
import cn.sliew.carp.module.security.core.repository.mapper.SecUserRoleMapper;
import cn.sliew.carp.module.security.core.service.SecUserRoleService;
import cn.sliew.carp.module.security.core.service.convert.SecRoleConvert;
import cn.sliew.carp.module.security.core.service.convert.SecUserConvert;
import cn.sliew.carp.module.security.core.service.dto.SecRoleDTO;
import cn.sliew.carp.module.security.core.service.dto.SecUserDTO;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleBatchAuthorizeForUserParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleListByUserParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecUserBatchAuthorizeForRoleParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecUserListByRoleParam;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SecUserRoleServiceImpl
extends ServiceImpl<SecUserRoleMapper, SecUserRole>
implements SecUserRoleService {
    @Override
    public PageResult<SecUserDTO> listAuthorizedUsersByRoleId(SecUserListByRoleParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page<SecUser> secUserPage = ((SecUserRoleMapper)this.baseMapper).selectRelatedUsersByRole(page, param.getRoleId(), param.getStatus(), param.getUserName());
        PageResult result = new PageResult(Long.valueOf(secUserPage.getCurrent()), Long.valueOf(secUserPage.getSize()), Long.valueOf(secUserPage.getTotal()));
        List secUserDTOS = SecUserConvert.INSTANCE.toDto(secUserPage.getRecords());
        result.setRecords(secUserDTOS);
        return result;
    }

    @Override
    public PageResult<SecUserDTO> listUnauthorizedUsersByRoleId(SecUserListByRoleParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page<SecUser> secUserPage = ((SecUserRoleMapper)this.baseMapper).selectUnrelatedUsersByRole(page, param.getRoleId(), param.getStatus(), param.getUserName());
        PageResult result = new PageResult(Long.valueOf(secUserPage.getCurrent()), Long.valueOf(secUserPage.getSize()), Long.valueOf(secUserPage.getTotal()));
        List secUserDTOS = SecUserConvert.INSTANCE.toDto(secUserPage.getRecords());
        result.setRecords(secUserDTOS);
        return result;
    }

    @Override
    public void authorize(SecUserBatchAuthorizeForRoleParam param) {
        ArrayList<SecUserRole> entities = new ArrayList<SecUserRole>();
        for (Long userId : param.getUserIds()) {
            SecUserRole record = new SecUserRole();
            record.setUserId(userId);
            record.setRoleId(param.getRoleId());
            entities.add(record);
        }
        this.saveBatch(entities);
    }

    @Override
    public void unauthorize(SecUserBatchAuthorizeForRoleParam param) {
        for (Long userId : param.getUserIds()) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecUserRole.class).eq(SecUserRole::getUserId, (Object)userId)).eq(SecUserRole::getRoleId, (Object)param.getRoleId());
            ((SecUserRoleMapper)this.baseMapper).delete((Wrapper)queryWrapper);
        }
    }

    @Override
    public void deleteByRoleId(Long roleId) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate(SecUserRole.class).eq(SecUserRole::getRoleId, (Object)roleId);
        ((SecUserRoleMapper)this.baseMapper).delete((Wrapper)updateWrapper);
    }

    @Override
    public List<SecRoleDTO> listAllAuthorizedRolesByUserId(SecRoleListByUserParam param) {
        List<SecRole> secRoleList = ((SecUserRoleMapper)this.baseMapper).selectRelatedRolesByUser(param.getUserId(), null, param.getName());
        return SecRoleConvert.INSTANCE.toDto(secRoleList);
    }

    @Override
    public PageResult<SecRoleDTO> listAuthorizedRolesByUserId(SecRoleListByUserParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page<SecRole> secRolePage = ((SecUserRoleMapper)this.baseMapper).selectRelatedRolesByUser(page, param.getUserId(), null, param.getName());
        PageResult result = new PageResult(Long.valueOf(secRolePage.getCurrent()), Long.valueOf(secRolePage.getSize()), Long.valueOf(secRolePage.getTotal()));
        List secRoleDTOS = SecRoleConvert.INSTANCE.toDto(secRolePage.getRecords());
        result.setRecords(secRoleDTOS);
        return result;
    }

    @Override
    public PageResult<SecRoleDTO> listUnauthorizedRolesByUserId(SecRoleListByUserParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page<SecRole> secRolePage = ((SecUserRoleMapper)this.baseMapper).selectUnrelatedRolesByUser(page, param.getUserId(), null, param.getName());
        PageResult result = new PageResult(Long.valueOf(secRolePage.getCurrent()), Long.valueOf(secRolePage.getSize()), Long.valueOf(secRolePage.getTotal()));
        List secRoleDTOS = SecRoleConvert.INSTANCE.toDto(secRolePage.getRecords());
        result.setRecords(secRoleDTOS);
        return result;
    }

    @Override
    public void authorize(SecRoleBatchAuthorizeForUserParam param) {
        ArrayList<SecUserRole> entities = new ArrayList<SecUserRole>();
        for (Long roleId : param.getRoleIds()) {
            SecUserRole record = new SecUserRole();
            record.setUserId(param.getUserId());
            record.setRoleId(roleId);
            entities.add(record);
        }
        this.saveBatch(entities);
    }

    @Override
    public void unauthorize(SecRoleBatchAuthorizeForUserParam param) {
        for (Long roleId : param.getRoleIds()) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecUserRole.class).eq(SecUserRole::getUserId, (Object)param.getUserId())).eq(SecUserRole::getRoleId, (Object)roleId);
            ((SecUserRoleMapper)this.baseMapper).delete((Wrapper)queryWrapper);
        }
    }

    @Override
    public void deleteByUserId(Long userId) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate(SecUserRole.class).eq(SecUserRole::getUserId, (Object)userId);
        ((SecUserRoleMapper)this.baseMapper).delete((Wrapper)updateWrapper);
    }
}

