/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.core.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.sliew.carp.framework.common.dict.security.CarpSecDeptStatus;
import cn.sliew.carp.framework.common.dict.security.CarpSecUserType;
import cn.sliew.carp.framework.common.model.BaseDTO;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.module.security.core.repository.entity.SecUser;
import cn.sliew.carp.module.security.core.repository.mapper.SecUserMapper;
import cn.sliew.carp.module.security.core.service.SecDeptService;
import cn.sliew.carp.module.security.core.service.SecUserRoleService;
import cn.sliew.carp.module.security.core.service.SecUserService;
import cn.sliew.carp.module.security.core.service.convert.SecUserConvert;
import cn.sliew.carp.module.security.core.service.dto.SecDeptDTO;
import cn.sliew.carp.module.security.core.service.dto.SecUserDTO;
import cn.sliew.carp.module.security.core.service.param.SecDeptListParam;
import cn.sliew.carp.module.security.core.service.param.SecUserAddParam;
import cn.sliew.carp.module.security.core.service.param.SecUserListParam;
import cn.sliew.carp.module.security.core.service.param.SecUserUpdateParam;
import cn.sliew.carp.module.security.core.util.PasswordUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SecUserServiceImpl
extends ServiceImpl<SecUserMapper, SecUser>
implements SecUserService {
    @Autowired
    private SecUserRoleService secUserRoleService;
    @Autowired
    private SecDeptService secDeptService;

    @Override
    public PageResult<SecUserDTO> page(SecUserListParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        List<Long> childDeptIds = this.recurse(param.getDeptId());
        Page<SecUser> secUserPage = ((SecUserMapper)this.baseMapper).list((Page<SecUser>)page, param, childDeptIds);
        PageResult pageResult = new PageResult(Long.valueOf(secUserPage.getCurrent()), Long.valueOf(secUserPage.getSize()), Long.valueOf(secUserPage.getTotal()));
        pageResult.setRecords(SecUserConvert.INSTANCE.toDto(secUserPage.getRecords()));
        return pageResult;
    }

    private List<Long> recurse(Long pid) {
        SecDeptListParam secDeptListParam = SecDeptListParam.builder().pid(pid).status(CarpSecDeptStatus.ENABLED).build();
        ArrayList deptIds = Lists.newArrayList();
        deptIds.add(pid);
        List<SecDeptDTO> secDeptDTOS = this.secDeptService.listAll(secDeptListParam);
        secDeptDTOS.stream().map(BaseDTO::getId).flatMap(childDeptId -> this.recurse((Long)childDeptId).stream()).forEach(deptIds::add);
        return deptIds;
    }

    @Override
    public List<SecUserDTO> listAll(SecUserListParam param) {
        List<SecUser> entities = ((SecUserMapper)this.baseMapper).list(param);
        return SecUserConvert.INSTANCE.toDto(entities);
    }

    @Override
    public SecUserDTO get(Long id) {
        SecUser entity = (SecUser)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("user not exists for id: " + id)));
        return (SecUserDTO)((Object)SecUserConvert.INSTANCE.toDto((Object)entity));
    }

    @Override
    public Optional<SecUserDTO> getByUserName(String userName) {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(SecUser.class).eq(SecUser::getUserName, (Object)userName);
        Optional optional = this.getOneOpt((Wrapper)queryChainWrapper);
        return optional.map(user -> (SecUserDTO)((Object)((Object)SecUserConvert.INSTANCE.toDto(user))));
    }

    @Override
    public boolean add(SecUserAddParam param) {
        SecUser entity = (SecUser)((Object)BeanUtil.copyProperties((Object)param, SecUser.class, (String[])new String[0]));
        entity.setType(CarpSecUserType.CUSTOM);
        entity.setSalt(RandomStringUtils.randomAlphanumeric((int)32));
        entity.setPassword(PasswordUtil.digestPassword(param.getPassword(), entity.getSalt()));
        return this.save((Object)entity);
    }

    @Override
    public boolean update(SecUserUpdateParam param) {
        SecUser entity = (SecUser)((Object)BeanUtil.copyProperties((Object)param, SecUser.class, (String[])new String[0]));
        return this.saveOrUpdate((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean delete(Long id) {
        this.secUserRoleService.deleteByUserId(id);
        return this.removeById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean deleteBatch(Collection<Long> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            ids.forEach(this::delete);
        }
        return true;
    }
}

