/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.QueueTransferTask;

public class QueueTransferService {
    private final Map<String, QueueTransferTask> tasks = new ConcurrentHashMap<String, QueueTransferTask>();

    public void schedule(String name, QueueTransferTask task) {
        QueueTransferTask oldTask = this.tasks.putIfAbsent(name, task);
        if (oldTask == null) {
            task.start();
        } else {
            oldTask.getLock().execute(() -> oldTask.incUsage());
        }
    }

    public void remove(String name) {
        QueueTransferTask task = this.tasks.get(name);
        if (task == null) {
            return;
        }
        task.getLock().execute(() -> {
            if (task.decUsage() == 0) {
                this.tasks.remove(name, task);
                task.stop();
            }
        });
    }
}

