/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.redisson.api.search.index.IndexType;

public final class IndexOptions {
    private List<String> prefix = Collections.emptyList();
    private String filter;
    private Double score;
    private String language;
    private Long temporary;
    private boolean noOffsets;
    private String languageField;
    private boolean maxTextFields;
    private boolean noFields;
    private String scoreField;
    private boolean noHL;
    private boolean noFreqs;
    private List<String> stopwords = Collections.emptyList();
    private boolean skipInitialScan;
    private IndexType on;
    private byte[] payloadField;

    private IndexOptions() {
    }

    public static IndexOptions defaults() {
        return new IndexOptions();
    }

    public IndexOptions on(IndexType dataType) {
        this.on = dataType;
        return this;
    }

    public IndexOptions prefix(String ... prefix) {
        return this.prefix(Arrays.asList(prefix));
    }

    public IndexOptions prefix(List<String> prefix) {
        this.prefix = prefix;
        return this;
    }

    public IndexOptions filter(String filter) {
        this.filter = filter;
        return this;
    }

    public IndexOptions language(String language) {
        this.language = language;
        return this;
    }

    public IndexOptions languageField(String languageField) {
        this.languageField = languageField;
        return this;
    }

    public IndexOptions score(Double score) {
        this.score = score;
        return this;
    }

    public IndexOptions scoreField(String scoreField) {
        this.scoreField = scoreField;
        return this;
    }

    public IndexOptions maxTextFields(boolean maxTextFields) {
        this.maxTextFields = maxTextFields;
        return this;
    }

    public IndexOptions noOffsets(boolean noOffsets) {
        this.noOffsets = noOffsets;
        return this;
    }

    public IndexOptions temporary(Long temporary) {
        this.temporary = temporary;
        return this;
    }

    public IndexOptions noHL(boolean noHL) {
        this.noHL = noHL;
        return this;
    }

    public IndexOptions noFields(boolean noFields) {
        this.noFields = noFields;
        return this;
    }

    public IndexOptions noFreqs(boolean noFreqs) {
        this.noFreqs = noFreqs;
        return this;
    }

    public IndexOptions stopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    public IndexOptions skipInitialScan(boolean skipInitialScan) {
        this.skipInitialScan = skipInitialScan;
        return this;
    }

    public IndexOptions payloadField(byte[] payloadField) {
        this.payloadField = payloadField;
        return this;
    }

    public List<String> getPrefix() {
        return this.prefix;
    }

    public String getFilter() {
        return this.filter;
    }

    public Double getScore() {
        return this.score;
    }

    public String getLanguage() {
        return this.language;
    }

    public Long getTemporary() {
        return this.temporary;
    }

    public boolean isNoOffsets() {
        return this.noOffsets;
    }

    public String getLanguageField() {
        return this.languageField;
    }

    public boolean isMaxTextFields() {
        return this.maxTextFields;
    }

    public boolean isNoFields() {
        return this.noFields;
    }

    public String getScoreField() {
        return this.scoreField;
    }

    public boolean isNoHL() {
        return this.noHL;
    }

    public boolean isNoFreqs() {
        return this.noFreqs;
    }

    public List<String> getStopwords() {
        return this.stopwords;
    }

    public boolean isSkipInitialScan() {
        return this.skipInitialScan;
    }

    public IndexType getOn() {
        return this.on;
    }

    public byte[] getPayloadField() {
        return this.payloadField;
    }
}

