/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.system.service.impl;

import cn.sliew.carp.framework.common.dict.CarpEnumDictRegistry;
import cn.sliew.carp.framework.common.dict.DictDefinition;
import cn.sliew.carp.framework.common.model.PageParam;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.spring.util.PageUtil;
import cn.sliew.carp.module.system.service.SysDictDefinitionService;
import cn.sliew.carp.module.system.service.param.SysDictDefinitionParam;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysDictDefinitionServiceImpl
implements SysDictDefinitionService {
    @Override
    public PageResult<DictDefinition> listByPage(SysDictDefinitionParam param) {
        Collection<DictDefinition> dictTypes = this.selectAll();
        List filteredDictTypes = dictTypes.stream().filter(dictType -> {
            if (StringUtils.hasText((String)param.getCode())) {
                return dictType.getCode().contains(param.getCode());
            }
            return true;
        }).filter(dictType -> {
            if (StringUtils.hasText((String)param.getName())) {
                return dictType.getName().contains(param.getName());
            }
            return true;
        }).collect(Collectors.toList());
        return PageUtil.buildPage((PageParam)param, filteredDictTypes);
    }

    @Override
    public Optional<DictDefinition> getByCode(String code) {
        return CarpEnumDictRegistry.INSTANCE.getDictDefinition(code);
    }

    @Override
    public Collection<DictDefinition> selectAll() {
        return CarpEnumDictRegistry.INSTANCE.getAllDefinitions();
    }
}

