/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.interceptor;

import cn.sliew.carp.framework.common.security.CarpSecurityContext;
import cn.sliew.carp.framework.common.security.OnlineUserInfo;
import cn.sliew.carp.framework.web.util.RequestParamUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.WebUtils;

public class AsyncWebLogInterceptor
implements AsyncHandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncWebLogInterceptor.class);
    private final TransmittableThreadLocal<Instant> threadState = new TransmittableThreadLocal();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.enableLog(request)) {
            this.threadState.set((Object)Instant.now());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            this.logQuery(request, response, handler);
            ContentCachingResponseWrapper responseWrapper = (ContentCachingResponseWrapper)WebUtils.getNativeResponse((ServletResponse)response, ContentCachingResponseWrapper.class);
            if (responseWrapper != null) {
                responseWrapper.copyBodyToResponse();
            }
        }
        finally {
            this.threadState.remove();
        }
    }

    private boolean enableLog(HttpServletRequest request) {
        return !RequestParamUtil.ignorePath(request.getRequestURI()) && log.isDebugEnabled();
    }

    private void logQuery(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!this.enableLog(request)) {
            return;
        }
        Duration duration = Duration.between((Temporal)this.threadState.get(), Instant.now());
        String params = RequestParamUtil.formatRequestParams(request);
        OnlineUserInfo onlineUserInfo = CarpSecurityContext.get();
        String userName = "unknown";
        if (Objects.nonNull(onlineUserInfo)) {
            userName = onlineUserInfo.getUserName();
        }
        String module = "unknown";
        String desc = "unknow";
        if (Objects.nonNull(handler) && handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Pair<String, String> pair = RequestParamUtil.findModuleAndDesc(handlerMethod);
            module = (String)pair.getLeft();
            desc = (String)pair.getRight();
        }
        log.debug("{} {} {} {} {} {} {}", new Object[]{userName, module, desc, DurationFormatUtils.formatDurationHMS((long)duration.toMillis()), request.getMethod(), request.getRequestURI(), params});
    }
}

