/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.interceptor;

import cn.hutool.core.date.DateUtil;
import cn.sliew.carp.framework.common.security.CarpSecurityContext;
import cn.sliew.carp.framework.common.security.OnlineUserInfo;
import cn.sliew.carp.framework.log.enums.LogEntity;
import cn.sliew.carp.framework.log.model.LogRecord;
import cn.sliew.carp.framework.log.model.LogRequest;
import cn.sliew.carp.framework.log.model.LogResponse;
import cn.sliew.carp.framework.log.model.UserInfo;
import cn.sliew.carp.framework.log.service.CarpSystemLogActionService;
import cn.sliew.carp.framework.web.util.RequestParamUtil;
import cn.sliew.milky.common.util.JacksonUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.Sink;

@Component
public class LogbookWebLogSink
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookWebLogSink.class);
    @Autowired
    private CarpSystemLogActionService carpSystemLogActionService;

    public void write(Precorrelation precorrelation, HttpRequest request) throws IOException {
    }

    public void write(Correlation correlation, HttpRequest request, HttpResponse response) throws IOException {
        try {
            this.printLog(correlation, request, response);
        }
        catch (Exception e) {
            log.error("Log exceptions", (Throwable)e);
        }
    }

    public void printLog(Correlation correlation, HttpRequest request, HttpResponse response) throws IOException {
        HandlerMethod handlerMethod = RequestParamUtil.getHandlerMethod();
        if (Objects.isNull(handlerMethod)) {
            return;
        }
        LogRecord record = new LogRecord();
        Pair<String, String> pair = RequestParamUtil.findModuleAndDesc(handlerMethod);
        record.setModule((String)pair.getLeft());
        record.setDesc((String)pair.getRight());
        record.setStartTime(Date.from(correlation.getStart()));
        record.setEndTime(Date.from(correlation.getEnd()));
        record.setDuration(Long.valueOf(DateUtil.betweenMs((Date)record.getStartTime(), (Date)record.getEndTime())));
        UserInfo userInfo = new UserInfo();
        OnlineUserInfo onlineUserInfo = CarpSecurityContext.get();
        if (Objects.nonNull(onlineUserInfo)) {
            userInfo.setUserId(onlineUserInfo.getUserId().toString());
            userInfo.setUserName(onlineUserInfo.getUserName());
            userInfo.setNickName(onlineUserInfo.getNickName());
        }
        record.setUser(userInfo);
        LogRequest logRequest = new LogRequest();
        record.setRequest(logRequest);
        logRequest.setMethod(request.getMethod());
        logRequest.setPath(request.getPath());
        logRequest.setIp(request.getHost());
        LogResponse logResponse = new LogResponse();
        record.setResponse(logResponse);
        logResponse.setStatus(Integer.valueOf(response.getStatus()));
        Set<LogEntity> logEntities = RequestParamUtil.findLogEntry(handlerMethod);
        if (!CollectionUtils.isEmpty(logEntities)) {
            if (logEntities.contains(LogEntity.HTTP_REQUEST_HEADERS)) {
                logRequest.setHeaders((Map)request.getHeaders());
            }
            if (logEntities.contains(LogEntity.HTTP_RESPONSE_BODY)) {
                logRequest.setBody(request.getBodyAsString());
            }
            if (logEntities.contains(LogEntity.HTTP_REQUEST_PARAM)) {
                logRequest.setParam(request.getQuery());
            }
            if (logEntities.contains(LogEntity.HTTP_RESPONSE_BODY)) {
                logResponse.setBody(response.getBodyAsString());
            }
        }
        log.info("{}", (Object)JacksonUtil.toJsonString((Object)record));
    }
}

