/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.response;

import cn.sliew.carp.framework.common.model.ResponseVO;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

@Component
public class RequestWithResultMethodProcessor
implements HandlerMethodReturnValueHandler,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestWithResultMethodProcessor.class);
    @Autowired
    private RequestMappingHandlerAdapter adapter;
    private RequestResponseBodyMethodProcessor processor;

    public void afterPropertiesSet() {
        List unmodifiableList = this.adapter.getReturnValueHandlers();
        ArrayList<HandlerMethodReturnValueHandler> list = new ArrayList<HandlerMethodReturnValueHandler>(unmodifiableList.size());
        for (HandlerMethodReturnValueHandler returnValueHandler : unmodifiableList) {
            if (returnValueHandler instanceof RequestResponseBodyMethodProcessor) {
                this.processor = (RequestResponseBodyMethodProcessor)returnValueHandler;
                list.add(this);
                continue;
            }
            list.add(returnValueHandler);
        }
        this.adapter.setReturnValueHandlers(list);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws IOException, HttpMediaTypeNotAcceptableException, HttpMessageNotWritableException {
        if (this.supportWithResult(returnType)) {
            ResponseVO response = this.convertValue(returnValue);
            this.processor.handleReturnValue((Object)response, returnType, mavContainer, webRequest);
        } else {
            this.processor.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
        }
    }

    private ResponseVO convertValue(Object returnValue) {
        return ResponseVO.success((Object)returnValue);
    }

    private boolean supportWithResult(MethodParameter returnType) {
        if (returnType.getMethod().getReturnType().equals(ResponseVO.class)) {
            return false;
        }
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType.getContainingClass(), ApiResponseWrapper.class) || returnType.hasMethodAnnotation(ApiResponseWrapper.class);
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.processor.supportsReturnType(returnType);
    }
}

