/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.util;

import cn.hutool.extra.spring.SpringUtil;
import cn.sliew.carp.framework.log.annotation.WebLog;
import cn.sliew.carp.framework.log.enums.LogEntity;
import cn.sliew.milky.common.util.JacksonUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

public class RequestParamUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestParamUtil.class);
    private static String contextPath;
    private static final String IGNORE_CONTENT_TYPE = "multipart/form-data";
    private static List<String> DEFAULT_IGNORE_PATH;
    private static List<String> IGNORE_PATH;
    private static final AntPathMatcher ANT_PATH_MATCHER;

    public static String formatRequestParams(HttpServletRequest request) {
        StringBuilder params = new StringBuilder();
        if (!RequestParamUtil.ignoreContentType(request.getContentType())) {
            String body;
            String parameters = RequestParamUtil.getRequestParams(request);
            if (StringUtils.hasText((String)parameters)) {
                params.append("uri_params: [");
                params.append(parameters);
                params.append("]");
            }
            if (StringUtils.hasText((String)(body = RequestParamUtil.getRequestBody(request)))) {
                if (params.length() != 0) {
                    params.append(", request_body: [");
                } else {
                    params.append("request_body: [");
                }
                params.append(body);
                params.append("]");
            }
        }
        return params.toString();
    }

    public static String getRequestParams(HttpServletRequest request) {
        if (request.getParameterMap().isEmpty()) {
            return "";
        }
        HashMap<String, Object> query = new HashMap<String, Object>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            if (value == null || value.length == 0) {
                query.put(key, null);
                continue;
            }
            if (value.length == 1) {
                query.put(key, value[0]);
                continue;
            }
            query.put(key, value);
        }
        return JacksonUtil.toJsonString(query);
    }

    public static String getRequestBody(HttpServletRequest request) {
        byte[] buf;
        ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingRequestWrapper.class);
        if (wrapper != null && (buf = wrapper.getContentAsByteArray()).length > 0) {
            String payload;
            try {
                payload = new String(buf, 0, buf.length, wrapper.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                payload = "[unknown]";
            }
            return payload.replaceAll("\\n", "");
        }
        return "";
    }

    public static boolean isRequestValid(HttpServletRequest request) {
        try {
            new URI(request.getRequestURL().toString());
            return true;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    public static boolean ignorePath(String uri) {
        return RequestParamUtil.getIgnorePaths().stream().filter(pattern -> ANT_PATH_MATCHER.match(pattern, uri)).findAny().isPresent();
    }

    public static boolean ignoreContentType(String contentType) {
        return StringUtils.hasText((String)contentType) && contentType.startsWith(IGNORE_CONTENT_TYPE);
    }

    public static List<String> getIgnorePaths() {
        if (CollectionUtils.isEmpty(IGNORE_PATH) && StringUtils.hasText((String)RequestParamUtil.getContextPath())) {
            IGNORE_PATH = RequestParamUtil.getDefaultIgnorePaths().stream().map(path -> "/" + RequestParamUtil.getContextPath() + path).collect(Collectors.toList());
        }
        return IGNORE_PATH;
    }

    public static List<String> getDefaultIgnorePaths() {
        return DEFAULT_IGNORE_PATH;
    }

    public static String getContextPath() {
        if (StringUtils.hasText((String)contextPath)) {
            return contextPath;
        }
        contextPath = SpringUtil.getProperty((String)"server.servlet.context-path");
        return contextPath;
    }

    public static HandlerMethod getHandlerMethod() {
        Object handler;
        ServletRequestAttributes servletRequestAttributes;
        HttpServletRequest httpServletRequest;
        Optional<Object> optional;
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (Objects.nonNull(requestAttributes) && requestAttributes instanceof ServletRequestAttributes && (optional = Optional.ofNullable(httpServletRequest = (servletRequestAttributes = (ServletRequestAttributes)requestAttributes).getRequest()).map(object -> {
            try {
                RequestMappingInfoHandlerMapping handlerMapping = (RequestMappingInfoHandlerMapping)SpringUtil.getBean((String)"requestMappingHandlerMapping", RequestMappingInfoHandlerMapping.class);
                return handlerMapping.getHandler(httpServletRequest);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }).map(chain -> chain.getHandler())).isPresent() && (handler = optional.get()) instanceof HandlerMethod) {
            return (HandlerMethod)handler;
        }
        return null;
    }

    public static Set<LogEntity> findLogEntry(HandlerMethod handlerMethod) {
        WebLog methodWebLog = (WebLog)handlerMethod.getMethodAnnotation(WebLog.class);
        WebLog classWebLog = handlerMethod.getBeanType().getDeclaredAnnotation(WebLog.class);
        return LogEntity.getIncludes((WebLog)methodWebLog, (WebLog)classWebLog);
    }

    public static Pair<String, String> findModuleAndDesc(HandlerMethod handlerMethod) {
        Operation operation;
        WebLog methodWebLog = (WebLog)handlerMethod.getMethodAnnotation(WebLog.class);
        WebLog classWebLog = handlerMethod.getBeanType().getDeclaredAnnotation(WebLog.class);
        String module = null;
        String desc = null;
        if (Objects.nonNull(methodWebLog)) {
            module = methodWebLog.module();
            desc = methodWebLog.desc();
        }
        if (Objects.nonNull(classWebLog)) {
            if (!StringUtils.hasText((String)module)) {
                module = classWebLog.module();
            }
            if (!StringUtils.hasText((String)desc)) {
                desc = classWebLog.desc();
            }
        }
        if (!StringUtils.hasText((String)module)) {
            Tag tag = handlerMethod.getBeanType().getDeclaredAnnotation(Tag.class);
            module = Optional.ofNullable(tag).map(Tag::name).orElse(null);
        }
        if (!StringUtils.hasText((String)desc) && Objects.nonNull(operation = (Operation)handlerMethod.getMethodAnnotation(Operation.class))) {
            desc = StringUtils.hasText((String)operation.summary()) ? operation.summary() : operation.description();
        }
        return Pair.of((Object)module, (Object)desc);
    }

    static {
        DEFAULT_IGNORE_PATH = Arrays.asList("/doc.html", "/swagger-resources", "/webjars/**", "/v3/api-docs/**", "/favicon.ico", "/ui/**/**");
        IGNORE_PATH = Collections.emptyList();
        ANT_PATH_MATCHER = new AntPathMatcher();
    }
}

