/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.quartz.service;

import cn.sliew.carp.module.scheduler.executor.api.executor.JobExecutor;
import cn.sliew.carp.module.scheduler.executor.api.executor.entity.ScheduleResponse;
import cn.sliew.carp.module.scheduler.executor.api.executor.entity.trigger.TriggerParam;
import cn.sliew.carp.module.scheduler.service.ScheduleJobInstanceService;
import cn.sliew.carp.module.scheduler.service.dto.ScheduleJobConfigDTO;
import cn.sliew.carp.module.scheduler.service.dto.ScheduleJobInstanceDTO;
import cn.sliew.milky.common.util.JacksonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.StringUtils;

public class QuartzJobHandler
extends QuartzJobBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzJobHandler.class);
    @Autowired
    private JobExecutor jobExecutor;
    @Autowired
    private ScheduleJobInstanceService scheduleJobInstanceService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getMergedJobDataMap();
        Long jobInstanceId = dataMap.getLong("CARP_JOB_INSTANCE_ID");
        ScheduleJobInstanceDTO scheduleJobInstanceDTO = this.scheduleJobInstanceService.get(jobInstanceId);
        ScheduleJobConfigDTO scheduleJobConfigDTO = scheduleJobInstanceDTO.getJobConfig();
        TriggerParam triggerParam = new TriggerParam();
        triggerParam.setJobId(scheduleJobConfigDTO.getId().toString());
        triggerParam.setJobInstanceId(scheduleJobInstanceDTO.getId().toString());
        triggerParam.setJobType(scheduleJobConfigDTO.getJobType().getValue());
        triggerParam.setExecuteType(scheduleJobConfigDTO.getExecuteType().getValue());
        triggerParam.setJobHandler(scheduleJobConfigDTO.getHandler());
        if (StringUtils.hasText((String)scheduleJobInstanceDTO.getParams())) {
            triggerParam.setParams(JacksonUtil.toMap((JsonNode)JacksonUtil.toJsonNode((String)scheduleJobInstanceDTO.getParams())));
        }
        triggerParam.setFireTime(context.getFireTime());
        triggerParam.setTriggerTime(context.getScheduledFireTime());
        ScheduleResponse response = this.jobExecutor.execute(triggerParam);
    }
}

